Object subclass: #HSDagLabel
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Diagnosis-Kernel-Extensions'!

"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

HSDagLabel class
	instanceVariableNames: ''!


!HSDagLabel class methodsFor: 'testing'!

isCloseLabel

	^false!

isEndLabel

	^false!

isNoLabel

	^false! !

!HSDagLabel class methodsFor: 'instance creation'!

new

	self shouldNotImplement! !

HSDagLabel subclass: #HSDagCloseLabel
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Diagnosis-Kernel-Extensions'!

"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

HSDagCloseLabel class
	instanceVariableNames: ''!


!HSDagCloseLabel class methodsFor: 'testing'!

isCloseLabel

	^true! !

SortedCollection variableSubclass: #HSDagStructure
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Diagnosis-Kernel-Extensions'!


!HSDagStructure methodsFor: 'adding'!

addNode: aNode
	"Add a new node to the structure."

	|  index el |
	index := aNode h withoutOK size.
	self elementsDo:[ :se |
		se index = index
		ifTrue:[ se add: aNode. ^se ].].
	el := HSDagStructureElement new.
	el index: index.
	el add: aNode.
	^self add: el! !

!HSDagStructure methodsFor: 'enumerating'!

do: aBlock 
	"Evaluate aBlock with each of the receiver's elements as the argument."

	firstIndex to: lastIndex do:
		[:index | (self basicAt: index) fifo do:[ :el | aBlock value: el].].!

elementsDo: aBlock 
	"Evaluate aBlock with each of the receiver's elements as the argument."

	firstIndex to: lastIndex do:
		[:index | aBlock value: (self basicAt: index)]! !

HSDagNode subclass: #HSDagNodeMultipleFM
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Diagnosis-Kernel-Extensions'!


!HSDagNodeMultipleFM methodsFor: 'initialization'!

init

	prev := OrderedCollection new.
	next := OrderedCollection new.
	h := ExtendedDiagnosis new.
	label := nil.
	probability := (1.00).

	^self! !

!HSDagNodeMultipleFM methodsFor: 'printing'!

printOn: aStream

	aStream nextPutAll: 'HSDagNode('.
	self h printOn: aStream.
	aStream nextPutAll: '| '.
	self label printOn: aStream.
	aStream nextPutAll: ') '.! !

!HSDagNodeMultipleFM methodsFor: 'public'!

answerDiagnoses

	| result |

	result := DiagnoseSet new.
	(self label isNil) ifTrue:[ ^result] .
	(self hasEndLabel) ifTrue:[ result add: (self h withoutOK). ^result ].
	(self hasCloseLabel) ifTrue:[ ^result. ].

	self next do:[ :n | 
		result addAll: (n node answerDiagnoses)].

	^result! !
"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

HSDagNodeMultipleFM class
	instanceVariableNames: ''!


!HSDagNodeMultipleFM class methodsFor: 'label names'!

closeLabel

	^HSDagCloseLabel!

endLabel

	^HSDagEndLabel!

noLabel

	^HSDagNoLabel! !

HSDagLabel subclass: #HSDagEndLabel
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Diagnosis-Kernel-Extensions'!

"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

HSDagEndLabel class
	instanceVariableNames: ''!


!HSDagEndLabel class methodsFor: 'testing'!

isEndLabel

	^true! !

HSDag subclass: #HSDagMultipleFM
	instanceVariableNames: 'withProbabilities iterative '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Diagnosis-Kernel-Extensions'!


!HSDagMultipleFM methodsFor: 'dag generation'!

breadthFirst: aTheoremProver with: aSet with: aSF with: diagSize with: numberOfDiagnoses
	"Creates new nodes using aTheoremProver, a set of nodes and a ordered collection of
	previously created conflict sets. Pruning, node reusing and node closing is used to
	compute the smallest possible graph."

	| nSet |

	nSet := aSet first.
	((nSet index < diagSize) or:[ iterative and:[ self endNodes size = 0]])
	ifTrue:[
	[ (nSet fifo isEmpty)]
	whileFalse:[ | n|
		n := nSet fifo first.
		nSet fifo removeFirst.
		(aTheoremProver isAssumeable: (n h))
		ifFalse:[ 
			n label: (HSDagNodeMultipleFM closeLabel).]
		ifTrue:[
			(self closeNode: n)
			ifFalse:[
				self searchForConflict: n with: aSF.
				(n label isNil)
				ifTrue:[
					theoremProverCalls := theoremProverCalls + 1.
					n label: (aTheoremProver getConflictSet: (n h)).
					(n label isEndLabel)
					ifFalse:[
						aSF addLast: (n label).
						self pruneNode: n with: aSF.].].
				(n label isEndLabel)
				ifTrue:[
					"Compute only numberOfDiagnoses end nodes."
					self endNodes add: n.
					(self endNodes size) >= numberOfDiagnoses
					ifTrue:[^self topNode.].]
				ifFalse:[
					(n label isCloseLabel)
					ifFalse:[
						(n label asOrderedCollection) do:[ :al | | nn |
							(((nSet index < (diagSize - 1))
							or: [(al mode = (al nabMode))])
							or:[ iterative and:[ self endNodes size = 0]])
							ifTrue:[ 
								(n h includesComponent: (al component))
								ifFalse:[
									nn := self reuseNode: n with: al with: aSet.
									withProbabilities ifTrue:[ self nodeProbability: nn theoremProver: aTheoremProver.].
									n next add: (HSDagArc node: nn label: al).].].].].].].].].
	aSet removeFirst.
	(aSet isEmpty) ifFalse:[^self breadthFirst: aTheoremProver with: aSet with: aSF with: diagSize with: numberOfDiagnoses].].
	^self topNode!

closeNode: aNode
	"A specific node is closed, e.g. no further calculation is done for this node
	if its history is a subset of a previously computed end node.
	This method answers true if aNode can be closed without loosing information
	and false otherwise."

	self endNodes do:[ :n |
		((n h withoutOK) subsumes: (aNode h withoutOK))
		ifTrue:[
			aNode label: (HSDagNodeMultipleFM closeLabel). ^true].].
	^false!

createHSDag: aTheoremProver with: diagSize with: numberOfDiagnoses
	"Creates a hitting set dag using a theorem prover loaded with SD, COMPS and OBS.
	The resulting hs dag size is smaller than diagSize."

	withProbabilities := false.
	iterative := false.
	^self generalCreateHSDag: aTheoremProver with: diagSize with: numberOfDiagnoses!

createHSDagUsingFaultProbabilities: aTheoremProver withDiagSize: aSize withNumberOfDiagnoses: aNumber
	"Computes  end nodes which are related to diagnoses with highest probability. The number
	of computed end nodes is restricted by aNumber."

	withProbabilities := true.
	iterative := false.
	^self generalCreateHSDag: aTheoremProver with: aSize with: aNumber!

createHSDagUsingFaultProbabilities: aTheoremProver withNumberOfDiagnoses: aNumber
	"Computes  end nodes which are related to diagnoses with highest probability. The number
	of computed end nodes is restricted by aNumber."

	withProbabilities := true.
	^self generalCreateHSDag: aTheoremProver with: 2 with: aNumber!

generalCreateHSDag: aTheoremProver with: diagSize with: numberOfDiagnoses

	| top sf str |

	top := HSDagNodeMultipleFM newTop.
	self nodes add: top.
	self topNode: top.

	sf := OrderedCollection new.
	withProbabilities
	ifTrue:[ 
		str := HSDagStructureProbability new.
		self nodeProbability: top theoremProver: aTheoremProver. ]
	ifFalse:[ str := HSDagStructure new. ].
	str addNode: top.
	self breadthFirst: aTheoremProver with: str with: sf with: (diagSize + 1) with: numberOfDiagnoses.
	^self!

iterativeCreateHSDag: aTheoremProver with: diagSize with: numberOfDiagnoses
	"Creates a hitting set dag using a theorem prover loaded with SD, COMPS and OBS.
	The resulting hs dag size is smaller than diagSize."

	withProbabilities := false.
	iterative := true.
	^self generalCreateHSDag: aTheoremProver with: diagSize with: numberOfDiagnoses!

nodeProbability: aNode theoremProver: aTheoremProver
	"Computes the probability of the given node using the component modes."

	| comps prob |
	comps := aTheoremProver focus asSet - (aNode h onlyComponents).
	prob := 1.
	comps do:[ :comp |
		prob := prob * (comp faultProbabilityValueFor: (comp nabMode)).].
	aNode h do:[ :cma |
		prob := prob * (cma component faultProbabilityValueFor: (cma mode)).].
	aNode probability: prob.!

pruneNode: aNode with: aSF
	"A node can be pruned if it do not provide new information for
	the hitting set tree. "

	| ds |
	self nodes do:[ :n | | ol |
		(n label isNil)
		ifFalse:[
			(n label  isEndLabel | (n label isCloseLabel) )
			ifFalse:[
				((aNode label) subset: (n label)) 
				ifTrue:[
					ol := n label - (aNode label).
					ds := aSF indexOf: (aNode label).
					aSF at: (aSF indexOf:(n label)) put: (aNode label).
					aSF at: ds put: (n label).
					n label: (aNode label).
					n next do:[ :ar |
						(ol includes: (ar label))
						ifTrue:[
							ar node prev remove: n ifAbsent:[nil].
							ar node remove: (self nodes).].].
					^true].].].].
	^false.!

reuseNode: n with: al with: aSet
	"This method answers an old node if n can be reused and new node
	otherwise."

	| nh nn |
	nh := (n h copy) add: al; yourself.
	self nodes do:[ :on |
		(on h = nh)
		ifTrue:[
			on prev add: n.
			^on ].].

	nn := HSDagNodeMultipleFM newNext: n.
	nn h: nh.
	aSet addNode: nn.
	self nodes add: nn.
	^nn!

searchForConflict: aNode with: aSF
	"Answers a conflict set where the intersection with aNodes h is
	empty."

	aNode label: nil.
	aSF do:[ :c |
		(c onlyComponents intersect: (aNode h onlyComponents)) isEmpty
		ifTrue:[ aNode label: c. ^aNode ].].
	^aNode! !

!HSDagMultipleFM methodsFor: 'initialize-release'!

initialize

	topNode := nil.
	theoremProverCalls := 0.
	nodes := Set new.
	endNodes := Set new.
	iterative := false.
	^self! !

Object variableSubclass: #HSDagStructureElement
	instanceVariableNames: 'index fifo '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Diagnosis-Kernel-Extensions'!


!HSDagStructureElement methodsFor: 'initialization'!

init

	index := nil.
	fifo := OrderedCollection new.
	^self! !

!HSDagStructureElement methodsFor: 'testing'!

< anElement

	^index < (anElement index)!

<= anElement

	^index <= (anElement index)!

> anElement

	^index > (anElement index)!

>= anElement

	^index >= (anElement index)! !

!HSDagStructureElement methodsFor: 'accessing'!

fifo

	^fifo!

fifo: anOrderedCollection

	^fifo := anOrderedCollection!

index

	^index!

index: aNumber

	^index := aNumber! !

!HSDagStructureElement methodsFor: 'public accessing'!

add: aNode
	"Adds a node to the fifo. Nodes, having an undef mode are put to the back."

	^fifo addLast: aNode! !

!HSDagStructureElement methodsFor: 'printing'!

printOn: aStream

	index printOn: aStream.
	aStream nextPutAll: ' -> '.
	fifo printOn: aStream.! !
"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

HSDagStructureElement class
	instanceVariableNames: ''!


!HSDagStructureElement class methodsFor: 'instance creation'!

new

	^super new init! !

HSDagStructure variableSubclass: #HSDagStructureProbability
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Diagnosis-Kernel-Extensions'!


!HSDagStructureProbability methodsFor: 'adding'!

addNode: aNode
	"Add a new node to the structure."

	|  index el |
	index := aNode probability.
	self elementsDo:[ :se |
		se index = index
		ifTrue:[ se add: aNode. ^se ].].
	el := HSDagStructureElement new.
	el index: index.
	el add: aNode.
	^self add: el! !

HSDagLabel subclass: #HSDagNoLabel
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Diagnosis-Kernel-Extensions'!

"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

HSDagNoLabel class
	instanceVariableNames: ''!


!HSDagNoLabel class methodsFor: 'testing'!

isNoLabel

	^true! !

