/*
 * Decompiled with CFR 0.152.
 */
package wizard;

import config.Memory;
import graph.GraphVisualization;
import graph.VisualizationResult;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DropMode;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;
import txtexport.TXTExport;

public class WizardPanel05
extends JPanel
implements ListSelectionListener {
    private static final long serialVersionUID = 1L;
    private JScrollPane jScrollPane2;
    private JScrollPane jScrollPane1;
    public JList jListPredicates;
    private JLabel jLabelFilter;
    private JPanel jPanel3;
    private JPanel jPanel2;
    private JButton jButtonExport;
    private JPanel jPanel1;
    public JTextArea textAreaResult;
    private VisualizationResult result;
    private JList jListModels;
    private JScrollPane jScrollPane;
    private JPanel jPanelLeft;
    private JLabel jLabel1;
    private GraphVisualization graph;

    public static void main(String[] args) {
        JFrame frame = new JFrame();
        frame.getContentPane().add(new WizardPanel05());
        frame.setDefaultCloseOperation(2);
        frame.pack();
        frame.setVisible(true);
    }

    public WizardPanel05() {
        this.initGUI();
    }

    public void update() {
        this.updateModelList();
        this.updateFilterList();
        this.updateValueList();
    }

    private void updateModelList() {
        this.result = Memory.getInstance().getVisResult();
        int modelCount = this.result.getAllModelEdges().size();
        Vector<String> mods = new Vector<String>();
        int i = 0;
        while (i < modelCount) {
            mods.add("Model " + (i + 1));
            ++i;
        }
        DefaultComboBoxModel listModel = new DefaultComboBoxModel(mods);
        this.jListModels.setModel(listModel);
        if (this.jListModels.getModel().getSize() > 0) {
            this.jListModels.setSelectedIndex(0);
            this.graph.update(0);
        }
    }

    private void updateFilterList() {
        Memory memory = Memory.getInstance();
        this.jListPredicates.setListData(memory.getResult().getPredicates().toArray());
    }

    private void updateValueList() {
        this.graph.updateValueList();
    }

    private void initGUI() {
        try {
            BorderLayout thisLayout = new BorderLayout();
            this.setLayout(thisLayout);
            this.setPreferredSize(new Dimension(400, 300));
            this.jPanel1 = new JPanel();
            BorderLayout jPanel1Layout = new BorderLayout();
            this.jPanel1.setLayout(jPanel1Layout);
            this.add((Component)this.jPanel1, "East");
            this.jPanel1.setPreferredSize(new Dimension(300, 274));
            JPanel jPanelResult = new JPanel(new BorderLayout());
            JLabel jLabelResult = new JLabel("Result of selected answersets (vertices):");
            jLabelResult.setBorder(BorderFactory.createEmptyBorder(15, 0, 3, 0));
            jPanelResult.add((Component)jLabelResult, "North");
            this.textAreaResult = new JTextArea();
            this.textAreaResult.setRows(6);
            this.textAreaResult.setEditable(false);
            this.textAreaResult.setDropMode(DropMode.USE_SELECTION);
            this.textAreaResult.setBorder(BorderFactory.createBevelBorder(1));
            this.jScrollPane2 = new JScrollPane(this.textAreaResult, 20, 30);
            jPanelResult.add((Component)this.jScrollPane2, "Center");
            this.jPanel1.add((Component)jPanelResult, "Center");
            this.jPanel2 = new JPanel();
            FlowLayout jPanel2Layout = new FlowLayout();
            jPanel2Layout.setAlignment(2);
            this.jPanel2.setLayout(jPanel2Layout);
            this.jPanel1.add((Component)this.jPanel2, "South");
            this.jPanel2.setPreferredSize(new Dimension(300, 37));
            this.jButtonExport = new JButton();
            this.jPanel2.add(this.jButtonExport);
            this.jButtonExport.setText("Export txt-File");
            this.jButtonExport.setHorizontalTextPosition(0);
            this.jButtonExport.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    WizardPanel05.this.jButtonExportActionPerformed(evt);
                }
            });
            this.jPanel3 = new JPanel();
            BorderLayout jPanel3Layout = new BorderLayout();
            this.jPanel1.add((Component)this.jPanel3, "North");
            this.jPanel3.setLayout(jPanel3Layout);
            this.jPanel3.setPreferredSize(new Dimension(300, 100));
            this.jLabelFilter = new JLabel();
            this.jPanel3.add((Component)this.jLabelFilter, "North");
            this.jLabelFilter.setText("Filter predicates:");
            this.jLabelFilter.setBorder(BorderFactory.createEmptyBorder(0, 0, 3, 0));
            DefaultComboBoxModel<String> jListPredicatesModel = new DefaultComboBoxModel<String>(new String[0]);
            this.jListPredicates = new JList();
            this.jListPredicates.setModel(jListPredicatesModel);
            this.jListPredicates.addListSelectionListener(this);
            this.jScrollPane1 = new JScrollPane(this.jListPredicates, 20, 30);
            this.jPanel3.add((Component)this.jScrollPane1, "Center");
            this.graph = new GraphVisualization(this.textAreaResult, this.jListPredicates);
            JPanel viewer = this.graph.getVisualizationViewer();
            JPanel viewerContainer = new JPanel(new BorderLayout());
            viewerContainer.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(0, 15, 0, 15), BorderFactory.createTitledBorder("Graph-Visualization:")));
            viewerContainer.add((Component)viewer, "Center");
            viewerContainer.add((Component)new JLabel("<html><body>Mouse-Left: Select/Move one or more vertices<br>Mouse-Wheel: Zoom<br>Mouse-Right: Move complete Graph</body><html>"), "South");
            this.add((Component)viewerContainer, "Center");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        DefaultComboBoxModel<String> listModel = new DefaultComboBoxModel<String>(new String[0]);
        this.jListModels = new JList();
        this.jListModels.setSelectionMode(0);
        this.jListModels.setModel(listModel);
        this.jListModels.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent arg0) {
                int index = WizardPanel05.this.jListModels.getSelectedIndex();
                if (index >= 0) {
                    WizardPanel05.this.graph.update(index);
                }
            }
        });
        this.jScrollPane = new JScrollPane(this.jListModels, 20, 30);
        this.jPanelLeft = new JPanel(new BorderLayout());
        this.add((Component)this.jPanelLeft, "West");
        this.jPanelLeft.add((Component)this.jScrollPane, "Center");
        this.jLabel1 = new JLabel();
        this.jPanelLeft.add((Component)this.jLabel1, "North");
        this.jLabel1.setText("Select a model:");
        this.jLabel1.setBorder(BorderFactory.createEmptyBorder(0, 0, 3, 0));
    }

    private void jButtonExportActionPerformed(ActionEvent evt) {
        System.out.println("jButtonExport.actionPerformed, event=" + evt);
        JFileChooser fc = new JFileChooser();
        fc.setFileFilter(new FileFilter(){

            @Override
            public String getDescription() {
                return "TXT-File(.txt)";
            }

            @Override
            public boolean accept(File f) {
                return f.getName().toLowerCase().endsWith(".txt") || f.isDirectory();
            }
        });
        fc.setDialogType(1);
        int retValue = fc.showDialog(this.getParent(), "Save");
        if (retValue == 0) {
            String path = String.valueOf(fc.getSelectedFile().getAbsolutePath()) + ".txt";
            TXTExport exporter = new TXTExport(path, Memory.getInstance());
            exporter.export();
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        this.updateValueList();
    }
}

