/*
 * Decompiled with CFR 0.152.
 */
package wizard;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;

public class ProgressViewer {
    private JPanel panel = new JPanel();
    private List<JLabel> labels = new ArrayList<JLabel>();
    private static ProgressViewer viewer;

    private ProgressViewer() {
        this.labels.add(new JLabel("Execution Base-Program"));
        this.labels.add(new JLabel("Code-Generation"));
        this.labels.add(new JLabel("Execution-Visualization"));
        this.labels.add(new JLabel("Edge/Highlight-Selection"));
        this.labels.add(new JLabel("Result-Graph"));
        ImageIcon icon = new ImageIcon(ClassLoader.getSystemClassLoader().getResource("img/icon.png"));
        icon = new ImageIcon(icon.getImage().getScaledInstance(40, 40, 100));
        this.panel.add(new JLabel(icon));
        this.panel.add(this.labels.get(0));
        this.panel.add(this.labels.get(1));
        this.panel.add(this.labels.get(2));
        this.panel.add(this.labels.get(3));
        this.panel.add(this.labels.get(4));
        this.setCurrentPanel(0);
    }

    public static ProgressViewer getInstance() {
        if (viewer == null) {
            viewer = new ProgressViewer();
        }
        return viewer;
    }

    public void setCurrentPanel(int index) {
        int i = 0;
        while (i < this.labels.size()) {
            Border paddingBorder = BorderFactory.createEmptyBorder(5, 5, 5, 5);
            Border activeBorder = BorderFactory.createLineBorder(Color.blue, 3);
            Border inactiveBorder = BorderFactory.createLineBorder(Color.lightGray, 1);
            if (i == index) {
                this.labels.get(i).setBorder(BorderFactory.createCompoundBorder(activeBorder, paddingBorder));
                this.labels.get(i).setForeground(Color.BLUE);
            } else {
                this.labels.get(i).setBorder(BorderFactory.createCompoundBorder(inactiveBorder, paddingBorder));
                this.labels.get(i).setForeground(Color.lightGray);
            }
            ++i;
        }
    }

    public JPanel getPanel() {
        return ProgressViewer.viewer.panel;
    }
}

