/*
 * Decompiled with CFR 0.152.
 */
package wizard;

import com.nexes.wizard.Wizard;
import com.nexes.wizard.WizardPanelDescriptor;
import config.ConfigurationDialog;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import wizard.ProgressViewer;
import wizard.WizardPanel01_Descriptor;
import wizard.WizardPanel02_Descriptor;
import wizard.WizardPanel03_Descriptor;
import wizard.WizardPanel04_Descriptor;
import wizard.WizardPanel05_Descriptor;

public class Main {
    private static WizardPanelDescriptor descriptor1;
    private static WizardPanelDescriptor descriptor3;

    public static void main(String[] args) {
        JFrame frame = new JFrame();
        frame.setTitle("ARVis");
        frame.setUndecorated(true);
        frame.setVisible(true);
        URL png = ClassLoader.getSystemClassLoader().getResource("img/icon.png");
        frame.setIconImage(new ImageIcon(png).getImage());
        Wizard wizard = new Wizard((Frame)frame);
        JMenuBar menuBar = Main.createMenu(wizard);
        wizard.getDialog().setJMenuBar(menuBar);
        wizard.getDialog().setMinimumSize(new Dimension(740, 400));
        wizard.getDialog().setTitle("Answer Set Relationship Visualizer");
        ProgressViewer viewer = ProgressViewer.getInstance();
        wizard.getDialog().add((Component)viewer.getPanel(), "North");
        wizard.getDialog().setLocationByPlatform(true);
        descriptor1 = new WizardPanel01_Descriptor();
        wizard.registerWizardPanel((Object)"ExecuteDLV", descriptor1);
        WizardPanel02_Descriptor descriptor2 = new WizardPanel02_Descriptor();
        wizard.registerWizardPanel((Object)"SelectPredicates", (WizardPanelDescriptor)descriptor2);
        descriptor3 = new WizardPanel03_Descriptor();
        wizard.registerWizardPanel((Object)"GenerateAS", descriptor3);
        WizardPanel04_Descriptor descriptor4 = new WizardPanel04_Descriptor();
        wizard.registerWizardPanel((Object)"GenerateGraph", (WizardPanelDescriptor)descriptor4);
        WizardPanel05_Descriptor descriptor5 = new WizardPanel05_Descriptor();
        wizard.registerWizardPanel((Object)"Result", (WizardPanelDescriptor)descriptor5);
        wizard.setCurrentPanel((Object)"ExecuteDLV");
        wizard.showModalDialog();
        System.exit(0);
    }

    private static JMenuBar createMenu(final Wizard wizard) {
        JMenuBar menuBar = new JMenuBar();
        JMenu menu = new JMenu("Start");
        menu.getAccessibleContext().setAccessibleDescription("Start-Menu");
        menuBar.add(menu);
        JMenuItem menuItemClear = new JMenuItem("Reset", 84);
        menuItemClear.getAccessibleContext().setAccessibleDescription("Starts from the beginning");
        menuItemClear.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                wizard.setCurrentPanel((Object)"ExecuteDLV");
                ((WizardPanel01_Descriptor)descriptor1).clearFields();
                ((WizardPanel03_Descriptor)descriptor3).clearFields();
            }
        });
        menu.add(menuItemClear);
        JMenuItem menuItem = new JMenuItem("Configuration", 84);
        menuItem.getAccessibleContext().setAccessibleDescription("Opens the configuration");
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                ConfigurationDialog dialog = new ConfigurationDialog(wizard.getDialog(), "Configuration");
                dialog.setDefaultCloseOperation(2);
                dialog.pack();
                dialog.setVisible(true);
            }
        });
        menu.add(menuItem);
        return menuBar;
    }
}

