/*
 * Decompiled with CFR 0.152.
 */
package wizard;

import asp.Result;
import asp.wrapper.ASPWrapper;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import wizard.ASExecution;

public class ASExecutionDialog
extends JDialog
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private JButton cancelButton;
    private ASExecution exec;
    private Thread execThread;

    public ASExecutionDialog(JDialog parent, ASPWrapper wrapper) {
        super(parent);
        this.setTitle("ASP-Solver is executing...");
        this.cancelButton = new JButton("Cancel");
        this.cancelButton.addActionListener(this);
        this.setLayout(new BorderLayout());
        URL gifWait = ClassLoader.getSystemClassLoader().getResource("img/wait.gif");
        this.getContentPane().add((Component)new JLabel(new ImageIcon(gifWait)), "Center");
        this.setDefaultCloseOperation(2);
        this.getContentPane().add((Component)this.cancelButton, "South");
        this.setSize(300, 150);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent we) {
                ASExecutionDialog.this.actionPerformed(null);
            }
        });
        this.setLocale(parent.getLocale());
        this.exec = new ASExecution(this);
        this.exec.setCurrentWrapper(wrapper);
        this.execThread = new Thread(this.exec);
        this.execThread.start();
        this.setModal(true);
        this.setLocationRelativeTo(parent);
        this.setVisible(true);
    }

    public Result getResult() {
        return this.exec.getResult();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.dispose();
        this.exec.stopExecution();
    }
}

