/*
 * Decompiled with CFR 0.152.
 */
package wizard;

import asp.Result;
import asp.wrapper.ASPWrapper;
import asp.wrapper.ExecutionException;
import asp.wrapper.ParserException;
import config.Utility;
import javax.swing.JDialog;
import javax.swing.JOptionPane;

public class ASExecution
implements Runnable {
    private ASPWrapper currentWrapper;
    private Result result = null;
    private JDialog dialog;

    public ASExecution(JDialog dial) {
        this.dialog = dial;
        this.result = null;
    }

    @Override
    public void run() {
        try {
            this.result = this.currentWrapper.execute();
            this.dialog.dispose();
        }
        catch (ParserException e) {
            this.dialog.dispose();
            this.setResult(null);
            JOptionPane.showMessageDialog(this.dialog, Utility.convertToMessage(e.getMessage()), "Parser Error", 0);
        }
        catch (ExecutionException e) {
            this.dialog.dispose();
            this.setResult(null);
            JOptionPane.showMessageDialog(this.dialog, Utility.convertToMessage(e.getMessage()), "Execution Error", 0);
        }
        catch (InterruptedException e) {
            this.setResult(null);
        }
    }

    public ASPWrapper getCurrentWrapper() {
        return this.currentWrapper;
    }

    public void setCurrentWrapper(ASPWrapper currentWrapper) {
        this.currentWrapper = currentWrapper;
    }

    public Result getResult() {
        return this.result;
    }

    public void setResult(Result result) {
        this.result = result;
    }

    public void stopExecution() {
        this.currentWrapper.stopExecution();
    }
}

