/*
 * Decompiled with CFR 0.152.
 */
package graph;

import asp.AnswerSet;
import asp.Literal;
import asp.Result;
import config.Config;
import config.Memory;
import graph.Edges;
import graph.Vertices;
import java.util.ArrayList;
import java.util.List;

public class VisualizationResult
extends Result {
    private List<Edges> edges = new ArrayList<Edges>();
    private List<Vertices> vertices = new ArrayList<Vertices>();

    public VisualizationResult(Result result) {
        super(result.getAnswerSets());
    }

    private void addEdges(Edges edges) {
        this.edges.add(edges);
    }

    public List<Edges> getAllModelEdges() {
        return this.edges;
    }

    public Edges getEdgesOfModel(int index) {
        return this.edges.get(index);
    }

    public void generateEdges(List<String> predicates, List<String> predicatesHighlighted) {
        Config config = Config.getInstance();
        boolean generateOneGraph = config.getBooleanProperty("generate_one_graph");
        int answerSetsNumber = Memory.getInstance().getResult().getAnswerSets().size();
        if (!generateOneGraph) {
            for (AnswerSet answerSet : this.getAnswerSets()) {
                Edges e = new Edges();
                Vertices v = new Vertices();
                for (Literal lit : answerSet.getLiterals()) {
                    try {
                        int to;
                        int from;
                        if (predicatesHighlighted.contains(String.valueOf(lit.getPredicate()) + " / " + lit.getTerms().size())) {
                            int vertex;
                            if (lit.getTerms().size() == 2) {
                                from = Integer.parseInt(lit.getTerms().get(0));
                                to = Integer.parseInt(lit.getTerms().get(1));
                                if (from >= 1 && from <= answerSetsNumber && to >= 1 && to <= answerSetsNumber) {
                                    e.add(from, to, true);
                                }
                            } else if (lit.getTerms().size() == 1 && (vertex = Integer.parseInt(lit.getTerms().get(0))) >= 1 && vertex <= answerSetsNumber) {
                                v.add(vertex);
                            }
                        }
                        if (!predicates.contains(String.valueOf(lit.getPredicate()) + " / " + lit.getTerms().size()) || lit.getTerms().size() != 2) continue;
                        from = Integer.parseInt(lit.getTerms().get(0));
                        to = Integer.parseInt(lit.getTerms().get(1));
                        if (from < 1 || from > answerSetsNumber || to < 1 || to > answerSetsNumber) continue;
                        e.add(from, to, false);
                    }
                    catch (Exception from) {
                        // empty catch block
                    }
                }
                this.addEdges(e);
                this.addVertices(v);
            }
        } else {
            Edges e = new Edges();
            Vertices v = new Vertices();
            for (AnswerSet answerSet : this.getAnswerSets()) {
                for (Literal lit : answerSet.getLiterals()) {
                    try {
                        int to;
                        if (predicatesHighlighted.contains(String.valueOf(lit.getPredicate()) + " / " + lit.getTerms().size())) {
                            int vertex;
                            if (lit.getTerms().size() == 2) {
                                int from = Integer.parseInt(lit.getTerms().get(0));
                                to = Integer.parseInt(lit.getTerms().get(1));
                                if (from >= 1 && from <= answerSetsNumber && to >= 1 && to <= answerSetsNumber) {
                                    e.add(from, to, true);
                                }
                            } else if (lit.getTerms().size() == 1 && (vertex = Integer.parseInt(lit.getTerms().get(0))) >= 1 && vertex <= answerSetsNumber) {
                                v.add(vertex);
                            }
                        }
                        if (!predicates.contains(String.valueOf(lit.getPredicate()) + " / " + lit.getTerms().size()) || lit.getTerms().size() != 2) continue;
                        int from = Integer.parseInt(lit.getTerms().get(0));
                        to = Integer.parseInt(lit.getTerms().get(1));
                        if (from < 1 || from > answerSetsNumber || to < 1 || to > answerSetsNumber) continue;
                        e.add(from, to, false);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            this.addEdges(e);
            this.addVertices(v);
        }
    }

    private void addVertices(Vertices v) {
        this.vertices.add(v);
    }

    public boolean isVertexHighlighted(int model, int vertex) {
        return this.vertices.get(model).isHighlighted(vertex);
    }
}

