/*
 * Decompiled with CFR 0.152.
 */
package graph;

import asp.AnswerSet;
import asp.Result;
import config.Memory;
import edu.uci.ics.jung.algorithms.layout.KKLayout;
import edu.uci.ics.jung.algorithms.layout.Layout;
import edu.uci.ics.jung.graph.DirectedSparseMultigraph;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.util.EdgeType;
import edu.uci.ics.jung.visualization.VisualizationViewer;
import edu.uci.ics.jung.visualization.control.CrossoverScalingControl;
import edu.uci.ics.jung.visualization.control.GraphMousePlugin;
import edu.uci.ics.jung.visualization.control.PluggableGraphMouse;
import edu.uci.ics.jung.visualization.control.ScalingControl;
import edu.uci.ics.jung.visualization.control.ScalingGraphMousePlugin;
import edu.uci.ics.jung.visualization.control.TranslatingGraphMousePlugin;
import edu.uci.ics.jung.visualization.decorators.EdgeShape;
import edu.uci.ics.jung.visualization.decorators.ToStringLabeller;
import edu.uci.ics.jung.visualization.renderers.Renderer;
import graph.Edges;
import graph.ModPickingGraphMousePlugin;
import graph.VisualizationResult;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.List;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import org.apache.commons.collections15.Transformer;

public class GraphVisualization
implements ItemListener {
    private Graph<Integer, Integer> g;
    private VisualizationViewer<Integer, Integer> vv;
    private JTextArea textAreaResult;
    private JList jListPredicates;
    private int currentModel;

    public GraphVisualization(JTextArea textAreaResult, JList jListPredicates) {
        this.textAreaResult = textAreaResult;
        this.jListPredicates = jListPredicates;
        this.g = new DirectedSparseMultigraph();
        KKLayout layout = new KKLayout(this.g);
        layout.setSize(new Dimension(200, 200));
        this.vv = new VisualizationViewer((Layout)layout);
        this.vv.setPreferredSize(new Dimension(250, 250));
        this.vv.getPickedVertexState().addItemListener((ItemListener)this);
        this.vv.getRenderContext().setVertexLabelTransformer((Transformer)new ToStringLabeller());
        this.vv.getRenderer().getVertexLabelRenderer().setPosition(Renderer.VertexLabel.Position.CNTR);
        PluggableGraphMouse gm = new PluggableGraphMouse();
        gm.add((GraphMousePlugin)new TranslatingGraphMousePlugin(4));
        gm.add((GraphMousePlugin)new ScalingGraphMousePlugin((ScalingControl)new CrossoverScalingControl(), 0, 1.1f, 0.9f));
        gm.add(new ModPickingGraphMousePlugin());
        this.vv.setGraphMouse((VisualizationViewer.GraphMouse)gm);
        this.vv.setAlignmentX(0.5f);
        this.vv.setAlignmentY(0.5f);
        Transformer<Integer, Paint> edgePaint = new Transformer<Integer, Paint>(){

            public Paint transform(Integer i) {
                if (Memory.getInstance().getVisResult().getEdgesOfModel(GraphVisualization.this.currentModel).get(i).isHighlighted()) {
                    return Color.red;
                }
                return Color.black;
            }
        };
        Transformer<Integer, Stroke> edgeStroke = new Transformer<Integer, Stroke>(){

            public Stroke transform(Integer i) {
                if (Memory.getInstance().getVisResult().getEdgesOfModel(GraphVisualization.this.currentModel).get(i).isHighlighted()) {
                    return new BasicStroke(2.0f, 0, 0, 10.0f);
                }
                return new BasicStroke(2.0f, 0, 0, 10.0f);
            }
        };
        Transformer<Integer, Paint> vertexBorder = new Transformer<Integer, Paint>(){

            public Paint transform(Integer i) {
                if (Memory.getInstance().getVisResult().isVertexHighlighted(GraphVisualization.this.currentModel, i)) {
                    return Color.red;
                }
                return Color.black;
            }
        };
        Transformer<Integer, Stroke> vertexStroke = new Transformer<Integer, Stroke>(){

            public Stroke transform(Integer i) {
                if (Memory.getInstance().getVisResult().isVertexHighlighted(GraphVisualization.this.currentModel, i)) {
                    return new BasicStroke(3.0f, 0, 0, 10.0f);
                }
                return new BasicStroke(1.5f, 0, 0, 10.0f);
            }
        };
        Transformer<Integer, Paint> vertexBackground = new Transformer<Integer, Paint>(){

            public Paint transform(Integer i) {
                if (GraphVisualization.this.vv.getPickedVertexState().isPicked((Object)i)) {
                    return Color.yellow;
                }
                return Color.white;
            }
        };
        this.vv.getRenderContext().setEdgeDrawPaintTransformer((Transformer)edgePaint);
        this.vv.getRenderContext().setArrowDrawPaintTransformer((Transformer)edgePaint);
        this.vv.getRenderContext().setArrowFillPaintTransformer((Transformer)edgePaint);
        this.vv.getRenderContext().setEdgeArrowStrokeTransformer((Transformer)edgeStroke);
        this.vv.getRenderContext().setEdgeStrokeTransformer((Transformer)edgeStroke);
        this.vv.getRenderContext().setVertexDrawPaintTransformer((Transformer)vertexBorder);
        this.vv.getRenderContext().setVertexStrokeTransformer((Transformer)vertexStroke);
        this.vv.getRenderContext().setVertexFillPaintTransformer((Transformer)vertexBackground);
        this.vv.getRenderContext().setEdgeShapeTransformer((Transformer)new EdgeShape.Line());
    }

    public void update(int index) {
        VisualizationResult visResult = Memory.getInstance().getVisResult();
        Result result = Memory.getInstance().getResult();
        Object[] vertices = this.g.getVertices().toArray();
        int i = 0;
        while (i < vertices.length) {
            this.g.removeVertex((Object)((Integer)vertices[i]));
            ++i;
        }
        i = 0;
        while (i < result.getAnswerSets().size()) {
            this.g.addVertex((Object)(i + 1));
            ++i;
        }
        Edges edges = visResult.getEdgesOfModel(index);
        this.currentModel = index;
        for (Integer id : edges.getAll()) {
            this.g.addEdge((Object)id, (Object)edges.get(id).getFrom(), (Object)edges.get(id).getTo(), EdgeType.DIRECTED);
        }
        this.vv.updateUI();
    }

    public JPanel getVisualizationViewer() {
        return this.vv;
    }

    @Override
    public void itemStateChanged(ItemEvent event) {
        this.updateValueList();
    }

    public void updateValueList() {
        String s = "";
        Object[] filter = this.jListPredicates.getSelectedValues();
        for (Integer i : this.vv.getRenderContext().getPickedVertexState().getPicked()) {
            List<AnswerSet> answerSets = Memory.getInstance().getResult().getAnswerSets();
            if (i > answerSets.size()) continue;
            AnswerSet model = answerSets.get(i - 1);
            s = String.valueOf(s) + "AnswerSet " + i + ":\n";
            s = String.valueOf(s) + model.toString(filter) + "\n-----------------------------------------\n";
        }
        this.textAreaResult.setText(s);
    }
}

