/*
 * Decompiled with CFR 0.152.
 */
package config;

import config.Config;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Properties;

public class Utility {
    public static final String CONFIG_NAME = "config.properties";

    public static Properties loadProperties() {
        FileInputStream is = null;
        try {
            is = new FileInputStream(CONFIG_NAME);
        }
        catch (FileNotFoundException e1) {
            File newfile = new File(CONFIG_NAME);
            try {
                newfile.createNewFile();
                Config c = Config.getInstance();
                c.write();
                is = new FileInputStream(CONFIG_NAME);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        Properties properties = new Properties();
        try {
            properties.load(is);
        }
        catch (Exception e) {
            System.err.println("Properties could not be read2!");
            return null;
        }
        return properties;
    }

    public static void storeProperties(Properties props) {
        PrintWriter writer;
        try {
            writer = new PrintWriter(CONFIG_NAME);
        }
        catch (FileNotFoundException e1) {
            e1.printStackTrace();
            return;
        }
        try {
            props.store(writer, "Comment");
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
    }

    public static String convertToMessage(String line) {
        int maxByLine = 80;
        char[] digit = line.toCharArray();
        int count = 0;
        int i = 0;
        while (i < digit.length) {
            if (++count > maxByLine && digit[i] == ' ') {
                digit[i] = 10;
                count = 0;
            }
            ++i;
        }
        return new String(digit);
    }
}

