/*
 * Decompiled with CFR 0.152.
 */
package config;

import config.ASP_Solver;
import config.Config;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import net.miginfocom.swing.MigLayout;

public class ConfigurationDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    private final JFileChooser fc_execution = new JFileChooser();
    private final JFileChooser path_Chooser = new JFileChooser();
    private JButton jButtonDLVPath;
    private JButton jButtonClingoPath;
    private JTextField jTextFieldExecute;
    private JTextField jTextFieldVisualize;
    private JTextField jTextFieldExec1;
    private JTextField jTextFieldExec2;
    private JTextField jTextFieldWDirectory;
    private JLabel jLabelExec1;
    private JLabel jLabelExec2;
    private JButton jButtonCancel;
    private JButton jButtonSave;
    private JButton jButtonWDirectory;
    private JLabel jLabel4;
    private JRadioButton jRadioButtonOther;
    private JPanel jPanelRadioButtons;
    private JPanel jPanel4;
    private JLabel jLabel1;
    private JPanel jPanel3;
    private JPanel jPanel2;
    private JPanel jPanel1;
    private JRadioButton jRadioButtonClingo;
    private JRadioButton jRadioButtonDLV;
    private ButtonGroup buttonGroupSolver;
    private JLabel jLabel3;
    private JLabel jLabel2;
    private JTextField jTextFieldPathDLV;
    private JTextField jTextFieldPathClingo;
    private JCheckBox jCheckBoxOneGraph;
    private Config config;

    public ConfigurationDialog(JDialog jDialog, String title) {
        super((Dialog)jDialog, title);
        this.initGUI();
        this.setLocationRelativeTo(jDialog);
        this.config = Config.getInstance();
        String path_DLV = this.config.getProperty("solver_path_dlv");
        String path_Clingo = this.config.getProperty("solver_path_clingo");
        String numberexe = this.config.getProperty("models_exec");
        String numberVis = this.config.getProperty("models_visualize");
        boolean oneGraph = this.config.getBooleanProperty("generate_one_graph");
        String solverString = this.config.getProperty("asp_solver");
        String exec1 = this.config.getProperty("other_exec1");
        String exec2 = this.config.getProperty("other_exec2");
        String wd = this.config.getProperty("other_working_directory");
        if (solverString == "") {
            solverString = ASP_Solver.DLV.name();
        }
        ASP_Solver solver = ASP_Solver.valueOf(solverString);
        this.jTextFieldPathDLV.setText(path_DLV);
        this.jTextFieldPathClingo.setText(path_Clingo);
        this.jTextFieldExecute.setText(numberexe);
        this.jTextFieldVisualize.setText(numberVis);
        this.jCheckBoxOneGraph.setSelected(oneGraph);
        this.jTextFieldExec1.setText(exec1);
        this.jTextFieldExec2.setText(exec2);
        this.jTextFieldWDirectory.setText(wd);
        if (solver == ASP_Solver.DLV) {
            this.jRadioButtonDLV.setSelected(true);
        } else if (solver == ASP_Solver.Clingo) {
            this.jRadioButtonClingo.setSelected(true);
        } else if (solver == ASP_Solver.Other) {
            this.jRadioButtonOther.setSelected(true);
        }
    }

    private void initGUI() {
        try {
            MigLayout thisLayout = new MigLayout();
            this.getContentPane().setLayout((LayoutManager)thisLayout);
            this.jTextFieldExecute = new JTextField();
            this.getContentPane().add((Component)this.jTextFieldExecute, "cell 1 1,growx");
            this.getContentPane().add((Component)this.getJPanel3(), "cell 0 2,growx");
            this.jTextFieldExecute.setMaximumSize(new Dimension(40, 22));
            this.jTextFieldExecute.setMargin(new Insets(1, 1, 1, 1));
            this.jTextFieldExecute.setHorizontalAlignment(4);
            this.jTextFieldVisualize = new JTextField();
            this.getContentPane().add((Component)this.jTextFieldVisualize, "cell 1 2 2 1,growx");
            this.jTextFieldVisualize.setHorizontalAlignment(4);
            this.jTextFieldVisualize.setMargin(new Insets(1, 1, 1, 1));
            this.jTextFieldVisualize.setMaximumSize(new Dimension(40, 22));
            this.jButtonSave = new JButton();
            this.getContentPane().add((Component)this.jButtonSave, "cell 1 6");
            this.jButtonSave.setText("Save");
            this.jButtonSave.setPreferredSize(new Dimension(63, 22));
            this.jButtonSave.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    ConfigurationDialog.this.jButtonSaveActionPerformed(evt);
                }
            });
            this.jButtonCancel = new JButton();
            this.getContentPane().add((Component)this.jButtonCancel, "cell 1 6");
            this.jButtonCancel.setText("Cancel");
            this.jButtonCancel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    ConfigurationDialog.this.jButtonCancelActionPerformed(evt);
                }
            });
            this.jRadioButtonDLV = new JRadioButton();
            this.jRadioButtonDLV.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent arg0) {
                    if (ConfigurationDialog.this.jRadioButtonDLV.isSelected()) {
                        ConfigurationDialog.this.jButtonDLVPath.setEnabled(true);
                        ConfigurationDialog.this.jTextFieldPathDLV.setEnabled(true);
                        ConfigurationDialog.this.jTextFieldPathDLV.setEditable(true);
                    } else {
                        ConfigurationDialog.this.jButtonDLVPath.setEnabled(false);
                        ConfigurationDialog.this.jTextFieldPathDLV.setEnabled(false);
                        ConfigurationDialog.this.jTextFieldPathDLV.setEditable(false);
                    }
                }
            });
            this.getContentPane().add((Component)this.jRadioButtonDLV, "cell 1 3");
            this.jRadioButtonDLV.setText("DLV");
            this.getButtonGroupSolver().add(this.jRadioButtonDLV);
            this.jRadioButtonClingo = new JRadioButton();
            this.jRadioButtonClingo.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent arg0) {
                    if (ConfigurationDialog.this.jRadioButtonClingo.isSelected()) {
                        ConfigurationDialog.this.jButtonClingoPath.setEnabled(true);
                        ConfigurationDialog.this.jTextFieldPathClingo.setEnabled(true);
                        ConfigurationDialog.this.jTextFieldPathClingo.setEditable(true);
                    } else {
                        ConfigurationDialog.this.jButtonClingoPath.setEnabled(false);
                        ConfigurationDialog.this.jTextFieldPathClingo.setEnabled(false);
                        ConfigurationDialog.this.jTextFieldPathClingo.setEditable(false);
                    }
                }
            });
            this.getContentPane().add((Component)this.jRadioButtonClingo, "cell 1 3");
            this.jRadioButtonClingo.setText("Clingo");
            this.getButtonGroupSolver().add(this.jRadioButtonClingo);
            this.jRadioButtonOther = new JRadioButton();
            this.getContentPane().add((Component)this.jRadioButtonOther, "cell 1 3");
            this.jRadioButtonOther.setText("Other");
            this.getButtonGroupSolver().add(this.jRadioButtonOther);
            this.jRadioButtonOther.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent arg0) {
                    if (ConfigurationDialog.this.jRadioButtonOther.isSelected()) {
                        ConfigurationDialog.this.jTextFieldExec1.setEditable(true);
                        ConfigurationDialog.this.jTextFieldExec2.setEditable(true);
                        ConfigurationDialog.this.jTextFieldWDirectory.setEditable(true);
                        ConfigurationDialog.this.jLabelExec1.setEnabled(true);
                        ConfigurationDialog.this.jLabelExec2.setEnabled(true);
                        ConfigurationDialog.this.jButtonWDirectory.setEnabled(true);
                        ConfigurationDialog.this.jTextFieldExec1.setEnabled(true);
                        ConfigurationDialog.this.jTextFieldExec2.setEnabled(true);
                        ConfigurationDialog.this.jTextFieldWDirectory.setEnabled(true);
                    } else {
                        ConfigurationDialog.this.jTextFieldExec1.setEditable(false);
                        ConfigurationDialog.this.jTextFieldExec2.setEditable(false);
                        ConfigurationDialog.this.jTextFieldWDirectory.setEditable(false);
                        ConfigurationDialog.this.jLabelExec1.setEnabled(false);
                        ConfigurationDialog.this.jLabelExec2.setEnabled(false);
                        ConfigurationDialog.this.jButtonWDirectory.setEnabled(false);
                        ConfigurationDialog.this.jTextFieldExec1.setEnabled(false);
                        ConfigurationDialog.this.jTextFieldExec2.setEnabled(false);
                        ConfigurationDialog.this.jTextFieldWDirectory.setEnabled(false);
                    }
                }
            });
            this.jPanelRadioButtons = new JPanel();
            this.jPanelRadioButtons.setEnabled(false);
            MigLayout jPanelOtherLayout = new MigLayout();
            this.jPanelRadioButtons.setLayout((LayoutManager)jPanelOtherLayout);
            this.jLabelExec1 = new JLabel("Base-Program-Execution:");
            this.jPanelRadioButtons.add((Component)this.jLabelExec1, "cell 0 2");
            this.jTextFieldExec1 = new JTextField();
            this.jPanelRadioButtons.add((Component)this.jTextFieldExec1, "cell 1 2, growx");
            this.jTextFieldExec1.setHorizontalAlignment(2);
            this.jTextFieldExec1.setMargin(new Insets(1, 1, 1, 1));
            this.jLabelExec2 = new JLabel("Visualization-Execution:");
            this.jPanelRadioButtons.add((Component)this.jLabelExec2, "cell 0 3");
            this.jTextFieldExec2 = new JTextField();
            this.jPanelRadioButtons.add((Component)this.jTextFieldExec2, "cell 1 3, growx");
            this.jTextFieldExec2.setHorizontalAlignment(2);
            this.jTextFieldExec2.setMargin(new Insets(1, 1, 1, 1));
            this.jTextFieldWDirectory = new JTextField();
            this.jPanelRadioButtons.add((Component)this.jTextFieldWDirectory, "cell 1 4,growx");
            this.jTextFieldWDirectory.setHorizontalAlignment(2);
            this.jTextFieldWDirectory.setMargin(new Insets(1, 1, 1, 1));
            this.jTextFieldExec1.setEditable(false);
            this.jTextFieldExec2.setEditable(false);
            this.jTextFieldWDirectory.setEditable(false);
            this.jTextFieldExec1.setEnabled(false);
            this.jTextFieldExec2.setEnabled(false);
            this.jTextFieldWDirectory.setEnabled(false);
            this.jLabelExec1.setEnabled(false);
            this.jLabelExec2.setEnabled(false);
            this.jTextFieldWDirectory.setMinimumSize(new Dimension(300, 22));
            this.jTextFieldWDirectory.setFocusable(true);
            this.jTextFieldPathDLV = new JTextField();
            this.jPanelRadioButtons.add((Component)this.jTextFieldPathDLV, "cell 1 0 2 1,growx");
            this.jTextFieldPathDLV.setMargin(new Insets(1, 1, 1, 1));
            this.jTextFieldPathDLV.setEnabled(false);
            this.jTextFieldPathDLV.setEditable(false);
            this.jButtonDLVPath = new JButton();
            this.jPanelRadioButtons.add((Component)this.jButtonDLVPath, "cell 0 0");
            this.jButtonDLVPath.setText("DLV-Solver-Path");
            this.jButtonDLVPath.setPreferredSize(new Dimension(140, 25));
            this.jButtonDLVPath.setLocation(new Point(0, 0));
            this.jButtonDLVPath.setEnabled(false);
            this.jButtonDLVPath.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    int retValue = ConfigurationDialog.this.fc_execution.showDialog(null, "Select");
                    if (retValue == 0) {
                        String value = ConfigurationDialog.this.fc_execution.getSelectedFile().getAbsolutePath();
                        ConfigurationDialog.this.config.setProperty("solver_path_dlv", value);
                        ConfigurationDialog.this.jTextFieldPathDLV.setText(value);
                    }
                }
            });
            this.jTextFieldPathClingo = new JTextField();
            this.jPanelRadioButtons.add((Component)this.jTextFieldPathClingo, "cell 1 1, growx");
            this.jTextFieldPathClingo.setMargin(new Insets(1, 1, 1, 1));
            this.jTextFieldPathClingo.setEnabled(false);
            this.jTextFieldPathClingo.setEditable(false);
            this.jButtonClingoPath = new JButton();
            this.jPanelRadioButtons.add((Component)this.jButtonClingoPath, "cell 0 1");
            this.jPanelRadioButtons.add((Component)this.getJButtonWDirectory(), "cell 0 4");
            this.jButtonClingoPath.setText("Clingo-Solver-Path");
            this.jButtonClingoPath.setEnabled(false);
            this.jButtonClingoPath.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    int retValue = ConfigurationDialog.this.fc_execution.showDialog(null, "Select");
                    if (retValue == 0) {
                        String value = ConfigurationDialog.this.fc_execution.getSelectedFile().getAbsolutePath();
                        ConfigurationDialog.this.config.setProperty("solver_path_clingo", value);
                        ConfigurationDialog.this.jTextFieldPathClingo.setText(value);
                    }
                }
            });
            this.getContentPane().add((Component)this.jPanelRadioButtons, "cell 0 4 2 1,growx");
            this.jCheckBoxOneGraph = new JCheckBox("");
            this.jCheckBoxOneGraph.setComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);
            this.jCheckBoxOneGraph.setHorizontalAlignment(4);
            this.getContentPane().add((Component)this.jCheckBoxOneGraph, "cell 1 5");
            this.getContentPane().add((Component)this.getJPanel1(), "cell 0 5,growx");
            this.getContentPane().add((Component)this.getJPanel2(), "cell 0 3,growx");
            this.getContentPane().add((Component)this.getJPanel4(), "cell 0 1,growx");
            this.jCheckBoxOneGraph.setHorizontalTextPosition(0);
            this.path_Chooser.setFileSelectionMode(1);
            this.setMinimumSize(new Dimension(700, 380));
            this.setPreferredSize(new Dimension(800, 380));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jButtonSaveActionPerformed(ActionEvent evt) {
        String path_dlv = this.jTextFieldPathDLV.getText();
        String path_clingo = this.jTextFieldPathClingo.getText();
        String numberexe = this.jTextFieldExecute.getText();
        String numbervisualize = this.jTextFieldVisualize.getText();
        Boolean oneGraph = this.jCheckBoxOneGraph.isSelected();
        String exec1 = this.jTextFieldExec1.getText();
        String exec2 = this.jTextFieldExec2.getText();
        String placeholder = this.jTextFieldWDirectory.getText();
        String solver = "";
        if (this.jRadioButtonClingo.isSelected()) {
            solver = ASP_Solver.Clingo.name();
        } else if (this.jRadioButtonDLV.isSelected()) {
            solver = ASP_Solver.DLV.name();
        } else if (this.jRadioButtonOther.isSelected()) {
            solver = ASP_Solver.Other.name();
        }
        this.config.setProperty("solver_path_dlv", path_dlv);
        this.config.setProperty("solver_path_clingo", path_clingo);
        this.config.setProperty("models_exec", numberexe);
        this.config.setProperty("models_visualize", numbervisualize);
        this.config.setProperty("asp_solver", solver);
        this.config.setProperty("generate_one_graph", oneGraph.toString());
        if (this.jRadioButtonOther.isSelected()) {
            this.config.setProperty("other_exec1", exec1);
            this.config.setProperty("other_exec2", exec2);
            this.config.setProperty("other_working_directory", placeholder);
        }
        this.config.write();
        this.dispose();
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private ButtonGroup getButtonGroupSolver() {
        if (this.buttonGroupSolver == null) {
            this.buttonGroupSolver = new ButtonGroup();
        }
        return this.buttonGroupSolver;
    }

    private JLabel getJLabel4() {
        if (this.jLabel4 == null) {
            this.jLabel4 = new JLabel();
            this.jLabel4.setText("generate only 1 graph:");
        }
        return this.jLabel4;
    }

    private JPanel getJPanel1() {
        if (this.jPanel1 == null) {
            this.jPanel1 = new JPanel();
            FlowLayout jPanel1Layout = new FlowLayout();
            jPanel1Layout.setAlignment(2);
            this.jPanel1.setLayout(jPanel1Layout);
            this.jPanel1.add(this.getJLabel4());
        }
        return this.jPanel1;
    }

    private JPanel getJPanel2() {
        if (this.jPanel2 == null) {
            this.jPanel2 = new JPanel();
            FlowLayout jPanel2Layout = new FlowLayout();
            jPanel2Layout.setAlignment(2);
            this.jPanel2.setLayout(jPanel2Layout);
            this.jPanel2.setSize(341, 25);
            this.jLabel3 = new JLabel();
            this.jPanel2.add(this.jLabel3);
            this.jLabel3.setText("ASP Solver:");
            this.jLabel3.setSize(144, 15);
            this.jLabel3.setFocusTraversalPolicyProvider(true);
        }
        return this.jPanel2;
    }

    private JPanel getJPanel3() {
        if (this.jPanel3 == null) {
            this.jPanel3 = new JPanel();
            FlowLayout jPanel3Layout = new FlowLayout();
            jPanel3Layout.setAlignment(2);
            this.jPanel3.setLayout(jPanel3Layout);
            this.jLabel2 = new JLabel();
            this.jPanel3.add(this.jLabel2);
            this.jLabel2.setText("number of models (for visualization):");
            this.jLabel2.setHorizontalAlignment(4);
            this.jLabel2.setHorizontalTextPosition(4);
        }
        return this.jPanel3;
    }

    private JLabel getJLabel1() {
        if (this.jLabel1 == null) {
            this.jLabel1 = new JLabel();
            this.jLabel1.setText("number of models (for execution):");
        }
        return this.jLabel1;
    }

    private JPanel getJPanel4() {
        if (this.jPanel4 == null) {
            this.jPanel4 = new JPanel();
            FlowLayout jPanel4Layout = new FlowLayout();
            jPanel4Layout.setAlignment(2);
            this.jPanel4.setLayout(jPanel4Layout);
            this.jPanel4.add(this.getJLabel1());
        }
        return this.jPanel4;
    }

    private JButton getJButtonWDirectory() {
        if (this.jButtonWDirectory == null) {
            this.jButtonWDirectory = new JButton();
            this.jButtonWDirectory.setEnabled(false);
            this.jButtonWDirectory.setText("Working-Directory");
            this.jButtonWDirectory.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    int retValue = ConfigurationDialog.this.path_Chooser.showDialog(null, "Select");
                    if (retValue == 0) {
                        String value = ConfigurationDialog.this.path_Chooser.getSelectedFile().getAbsolutePath();
                        ConfigurationDialog.this.config.setProperty("other_working_directory", value);
                        ConfigurationDialog.this.jTextFieldWDirectory.setText(value);
                    }
                }
            });
        }
        return this.jButtonWDirectory;
    }
}

