/*
 * Decompiled with CFR 0.152.
 */
package config;

import config.Utility;
import java.util.Properties;

public class Config {
    public static final String LAST_PATH = "LAST_PATH";
    public static final String NUMBER_OF_MODELS_VISUALIZE = "models_visualize";
    public static final String NUMBER_OF_MODELS_EXEC = "models_exec";
    public static final String SOLVER = "asp_solver";
    public static final String GENERATE_ONE_GRAPH = "generate_one_graph";
    public static final String OTHER_EXEC1 = "other_exec1";
    public static final String OTHER_EXEC2 = "other_exec2";
    public static final String OTHER_WORKING_DIRECTORY = "other_working_directory";
    public static final String SOLVER_PATH_DLV = "solver_path_dlv";
    public static final String SOLVER_PATH_CLINGO = "solver_path_clingo";
    private Properties props = Utility.loadProperties();
    private static Config config = null;

    private Config() {
        if (this.props == null || this.props.size() == 0) {
            this.props = new Properties();
            this.props.put(SOLVER_PATH_DLV, "");
            this.props.put(SOLVER_PATH_CLINGO, "");
            this.props.put(NUMBER_OF_MODELS_VISUALIZE, "100");
            this.props.put(NUMBER_OF_MODELS_EXEC, "100");
            this.props.put(SOLVER, "DLV");
            this.props.put(GENERATE_ONE_GRAPH, "False");
            this.props.put(OTHER_EXEC1, "");
            this.props.put(OTHER_EXEC2, "");
            this.props.put(OTHER_WORKING_DIRECTORY, "");
        }
    }

    public static Config getInstance() {
        if (config == null) {
            config = new Config();
        }
        return config;
    }

    public String getProperty(String key) {
        if (Config.config.props.containsKey(key)) {
            return Config.config.props.getProperty(key);
        }
        return "";
    }

    public Integer getIntProperty(String key) {
        if (Config.config.props.containsKey(key)) {
            String value = Config.config.props.getProperty(key);
            return Integer.parseInt(value);
        }
        return 0;
    }

    public Boolean getBooleanProperty(String key) {
        if (Config.config.props.containsKey(key)) {
            String value = Config.config.props.getProperty(key);
            return Boolean.parseBoolean(value);
        }
        return false;
    }

    public void setProperty(String key, String value) {
        if (Config.config.props.containsKey(key)) {
            Config.config.props.setProperty(key, value);
        } else {
            Config.config.props.put(key, value);
        }
    }

    public void write() {
        Utility.storeProperties(Config.config.props);
    }
}

