/*
 * Decompiled with CFR 0.152.
 */
package asp.wrapper;

import asp.Result;
import asp.wrapper.ASPWrapper;
import asp.wrapper.ClaspResultParser;
import asp.wrapper.ExecutionException;
import asp.wrapper.ParserException;
import config.Config;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Scanner;

public class GringoClaspWrapper
extends ASPWrapper {
    private boolean firstExecution;
    private Process process;

    protected GringoClaspWrapper(boolean firstExecution) {
        this.firstExecution = firstExecution;
    }

    @Override
    public Result execute() throws ExecutionException, ParserException, InterruptedException {
        String property;
        Config config = Config.getInstance();
        String executeString = config.getProperty(property = this.firstExecution ? "other_exec1" : "other_exec2");
        if (executeString.isEmpty()) {
            if (this.firstExecution) {
                throw new ExecutionException("The command field of the 'Base-Program-Execution' is empty. Please enter some valid commands in Menu -> Start -> Configuration");
            }
            throw new ExecutionException("The command field of the 'Visualization-Execution' is empty. Please enter some valid commands in Menu -> Start -> Configuration");
        }
        String execPath = config.getProperty("other_working_directory");
        if (!execPath.isEmpty() && !new File(execPath).isDirectory()) {
            throw new ExecutionException("The working directory is incorrect. Please enter a valid path in Menu -> Start -> Configuration");
        }
        String result = "";
        String error = "";
        String input = "";
        for (String file : this.files) {
            try {
                Scanner scanner = new Scanner(new FileReader(file));
                while (scanner.hasNextLine()) {
                    input = String.valueOf(input) + scanner.nextLine() + "\n";
                }
                scanner.close();
            }
            catch (FileNotFoundException scanner) {
                // empty catch block
            }
        }
        input = String.valueOf(input) + this.code;
        String[] exec_parts = executeString.split("\\|");
        try {
            int i = 0;
            while (i < exec_parts.length) {
                String line;
                File workingDir = null;
                if (!execPath.isEmpty()) {
                    workingDir = new File(execPath);
                }
                String exec = exec_parts[i].trim();
                String[] cmdParts = this.prepareExec(exec, execPath);
                this.process = Runtime.getRuntime().exec(cmdParts, null, workingDir);
                if (this.executionStopped) {
                    this.process.destroy();
                    throw new InterruptedException();
                }
                PrintWriter writer = new PrintWriter(this.process.getOutputStream());
                writer.print(input);
                writer.close();
                result = "";
                Scanner scanner = new Scanner(this.process.getInputStream());
                while (scanner.hasNextLine()) {
                    line = scanner.nextLine();
                    result = String.valueOf(result) + line + "\n";
                }
                scanner.close();
                scanner = new Scanner(this.process.getErrorStream());
                while (scanner.hasNextLine()) {
                    line = scanner.nextLine();
                    error = String.valueOf(error) + line + "\n";
                }
                scanner.close();
                input = result;
                if (this.executionStopped) {
                    throw new InterruptedException();
                }
                ++i;
            }
        }
        catch (InterruptedException e) {
            throw new InterruptedException();
        }
        catch (Exception e) {
            throw new ExecutionException(e.getMessage());
        }
        ClaspResultParser parser = new ClaspResultParser(result, error);
        return new Result(parser.getAnswerSets());
    }

    private String[] prepareExec(String exec, String workingDir) throws ExecutionException {
        if (workingDir == null) {
            workingDir = "";
        }
        exec = exec.trim();
        exec = exec.replace("\\", "/");
        workingDir = workingDir.replace("\\", "/");
        boolean inQuotes = false;
        String buffer = "";
        ArrayList<String> cmdList = new ArrayList<String>();
        int i = 0;
        while (i < exec.length()) {
            if (exec.charAt(i) == '\"') {
                inQuotes = !inQuotes;
            } else if (exec.charAt(i) == ' ' && !inQuotes) {
                cmdList.add(buffer);
                buffer = "";
            } else {
                buffer = String.valueOf(buffer) + exec.charAt(i);
            }
            ++i;
        }
        cmdList.add(buffer);
        String[] cmdParts = cmdList.toArray(new String[0]);
        if (!new File(cmdParts[0]).isAbsolute()) {
            cmdParts[0] = String.valueOf(workingDir) + "/" + cmdParts[0];
        }
        if (!new File(cmdParts[0]).isFile()) {
            throw new ExecutionException("The file \"" + cmdParts[0] + "\" is incorrect.\nPlease enter a valid file in Menu -> Start -> Configuration");
        }
        return cmdParts;
    }

    @Override
    public synchronized void stopExecution() {
        this.executionStopped = true;
        if (this.process != null) {
            this.process.destroy();
        }
    }
}

