/*
 * Decompiled with CFR 0.152.
 */
package asp.wrapper;

import DLV.DLVException;
import DLV.DLVInvocationException;
import DLV.DlvHandler;
import DLV.Model;
import DLV.Predicate;
import DLV.Program;
import asp.AnswerSet;
import asp.Literal;
import asp.Result;
import asp.wrapper.ASPWrapper;
import asp.wrapper.ExecutionException;
import asp.wrapper.ParserException;
import config.Config;
import java.io.File;
import java.util.ArrayList;

public class DLVWrapper
extends ASPWrapper {
    protected DLVWrapper() {
    }

    @Override
    public Result execute() throws ExecutionException, ParserException, InterruptedException {
        Program p = new Program();
        for (String file : this.files) {
            p.addProgramFile(file);
        }
        p.addString(this.code);
        int counter = 1;
        Config config = Config.getInstance();
        String path = config.getProperty("solver_path_dlv");
        if (path.isEmpty() || !new File(path).isFile()) {
            throw new ExecutionException("The execution file of DLV is incorrect. Please enter a valid path in Menu -> Start -> Configuration");
        }
        DlvHandler dlv = new DlvHandler(path);
        dlv.setProgram(p);
        dlv.setNumberOfModels(this.getMaxAnswerSets());
        dlv.setIncludeFacts(true);
        ArrayList<AnswerSet> answerSets = new ArrayList<AnswerSet>();
        try {
            try {
                dlv.run((byte)2);
                while (dlv.getStatus() != 2) {
                    Thread.sleep(100L);
                    if (!this.executionStopped) continue;
                    dlv.kill();
                    throw new InterruptedException();
                }
                while (dlv.hasMoreModels()) {
                    Model m = dlv.nextModel();
                    if (m.isNoModel()) continue;
                    AnswerSet answerSet = new AnswerSet(counter);
                    ++counter;
                    while (m.hasMorePredicates()) {
                        Predicate pr = m.nextPredicate();
                        while (pr.hasMoreLiterals()) {
                            Predicate.Literal lit = pr.nextLiteral();
                            String predicateName = "";
                            predicateName = lit.isPositive() ? lit.name() : "-" + pr.name();
                            Literal literal = new Literal(predicateName);
                            int i = 0;
                            while (i < lit.arity()) {
                                literal.addTerm(lit.getTermAt(i));
                                ++i;
                            }
                            answerSet.addLiteral(literal);
                        }
                    }
                    answerSets.add(answerSet);
                }
            }
            catch (DLVException e) {
                System.out.println(e.getMessage());
                throw new ExecutionException(e.getMessage());
            }
        }
        finally {
            try {
                String warning = dlv.getWarnings();
                if (warning != null && !warning.isEmpty()) {
                    System.err.println("Warnings: " + dlv.getWarnings());
                    throw new ParserException("DLV Warnings: " + warning);
                }
            }
            catch (DLVInvocationException dLVInvocationException) {}
        }
        return new Result(answerSets);
    }
}

