/*
 * Decompiled with CFR 0.152.
 */
package asp.wrapper;

import asp.Result;
import asp.wrapper.ASPWrapper;
import asp.wrapper.ClaspResultParser;
import asp.wrapper.ExecutionException;
import asp.wrapper.ParserException;
import config.Config;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Scanner;

public class ClingoWrapper
extends ASPWrapper {
    private Process process;

    protected ClingoWrapper() {
    }

    @Override
    public Result execute() throws ExecutionException, ParserException, InterruptedException {
        Config config = Config.getInstance();
        String path = config.getProperty("solver_path_clingo");
        ArrayList<String> cmdList = new ArrayList<String>();
        cmdList.add(path);
        String result = "";
        String error = "";
        if (path.isEmpty() || !new File(path).isFile()) {
            throw new ExecutionException("The execution file of Clingo is incorrect. Please enter a valid path in Menu -> Start -> Configuration");
        }
        cmdList.add("-n");
        cmdList.add(String.valueOf(this.getMaxAnswerSets()));
        String[] cmdParts = cmdList.toArray(new String[0]);
        String input = "";
        for (String file : this.files) {
            try {
                Scanner scanner = new Scanner(new FileReader(file));
                while (scanner.hasNextLine()) {
                    input = String.valueOf(input) + scanner.nextLine() + "\n";
                }
                scanner.close();
            }
            catch (FileNotFoundException scanner) {
                // empty catch block
            }
        }
        input = String.valueOf(input) + this.code;
        try {
            String line;
            this.process = Runtime.getRuntime().exec(cmdParts);
            if (this.executionStopped) {
                this.process.destroy();
                throw new InterruptedException();
            }
            PrintWriter writer = new PrintWriter(this.process.getOutputStream());
            writer.print(input);
            writer.close();
            Scanner scanner = new Scanner(this.process.getInputStream());
            while (scanner.hasNextLine()) {
                line = scanner.nextLine();
                result = String.valueOf(result) + line + "\n";
            }
            scanner = new Scanner(this.process.getErrorStream());
            while (scanner.hasNextLine()) {
                line = scanner.nextLine();
                error = String.valueOf(error) + line + "\n";
            }
            if (this.executionStopped) {
                throw new InterruptedException();
            }
        }
        catch (InterruptedException e) {
            throw new InterruptedException();
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            throw new ExecutionException(e.getMessage());
        }
        ClaspResultParser parser = new ClaspResultParser(result, error);
        return new Result(parser.getAnswerSets());
    }

    @Override
    public synchronized void stopExecution() {
        this.executionStopped = true;
        if (this.process != null) {
            this.process.destroy();
        }
    }
}

