/*
 * Decompiled with CFR 0.152.
 */
package asp.wrapper;

import asp.AnswerSet;
import asp.Literal;
import asp.wrapper.ParserException;
import java.util.ArrayList;
import java.util.List;

public class ClaspResultParser {
    private String result;
    private String error;

    public ClaspResultParser(String result) {
        this(result, "");
    }

    public ClaspResultParser(String result, String error) {
        this.result = result;
        this.error = error;
    }

    public List<AnswerSet> getAnswerSets() throws ParserException {
        ArrayList<AnswerSet> answerSets = new ArrayList<AnswerSet>();
        String[] lines = this.result.split("\\n");
        int offset = -1;
        int i = 0;
        while (i < lines.length) {
            if (lines[i].contains("Answer")) {
                offset = i;
                break;
            }
            ++i;
        }
        if (offset == -1) {
            if (this.result.contains("UNSATISFIABLE")) {
                return answerSets;
            }
            throw new ParserException("Could not parse the output of ASP-Solver. Returning error message:\n" + this.error);
        }
        int id = 1;
        int i2 = offset;
        while (i2 < lines.length) {
            if (lines[i2].equals("SATISFIABLE") || lines[i2].equals("UNSATISFIABLE") || lines[i2].equals("UNKNOW") || lines[i2].isEmpty()) break;
            if ((i2 - offset) % 2 != 0) {
                String[] lits = lines[i2].split(" ");
                AnswerSet answerSet = new AnswerSet(id);
                int j = 0;
                while (j < lits.length) {
                    Literal literal = new Literal(this.getPredicate(lits[j]), this.getTerms(lits[j]));
                    answerSet.addLiteral(literal);
                    ++j;
                }
                if (!answerSets.contains(answerSet)) {
                    answerSets.add(answerSet);
                    ++id;
                }
            }
            ++i2;
        }
        return answerSets;
    }

    private String getPredicate(String literal) {
        int index = literal.indexOf(40);
        if (index > 0) {
            return literal.substring(0, index);
        }
        return literal;
    }

    private List<String> getTerms(String lit) {
        int level = 0;
        ArrayList<String> terms = new ArrayList<String>();
        String term = "";
        int i = 0;
        while (i < lit.length()) {
            char c = lit.charAt(i);
            if (c == ')') {
                --level;
            }
            if (level == 1 && c == ',') {
                terms.add(term);
                term = "";
            } else if (level >= 1) {
                term = String.valueOf(term) + c;
            }
            if (c == '(') {
                ++level;
            }
            ++i;
        }
        if (!term.isEmpty()) {
            terms.add(term);
        }
        return terms;
    }
}

