/*
 * Decompiled with CFR 0.152.
 */
package asp.wrapper;

import asp.Result;
import asp.wrapper.ClingoWrapper;
import asp.wrapper.DLVWrapper;
import asp.wrapper.ExecutionException;
import asp.wrapper.GringoClaspWrapper;
import config.ASP_Solver;
import config.Config;
import java.util.ArrayList;
import java.util.List;

public abstract class ASPWrapper {
    protected List<String> files;
    protected String code;
    protected int maxAnswerSets;
    protected boolean executionStopped;

    protected ASPWrapper() {
        this.setFiles(new ArrayList<String>());
        this.setCode("");
        this.setMaxAnswerSets(0);
    }

    public static ASPWrapper createWrapper(boolean firstExecution) {
        Config config = Config.getInstance();
        String solver = config.getProperty("asp_solver");
        ASP_Solver asp_solver = ASP_Solver.valueOf(solver);
        if (asp_solver == ASP_Solver.Clingo) {
            return new ClingoWrapper();
        }
        if (asp_solver == ASP_Solver.Other) {
            return new GringoClaspWrapper(firstExecution);
        }
        return new DLVWrapper();
    }

    public void setMaxAnswerSets(int number) {
        this.maxAnswerSets = number;
    }

    public int getMaxAnswerSets() {
        return this.maxAnswerSets;
    }

    public void setFiles(List<String> files) {
        this.files = files;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public void addFile(String file) {
        this.files.add(file);
    }

    public void clear() {
        this.files.clear();
        this.code = "";
    }

    public synchronized void stopExecution() {
        this.executionStopped = true;
    }

    public abstract Result execute() throws ExecutionException, InterruptedException;
}

