/*
 * Decompiled with CFR 0.152.
 */
package asp;

import asp.AnswerSet;
import asp.Literal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class Result {
    private List<AnswerSet> answerSets;

    public Result(List<AnswerSet> answerSets) {
        this.answerSets = answerSets;
    }

    public List<String> getPredicates() {
        ArrayList<String> predicates = new ArrayList<String>();
        for (AnswerSet answerSet : this.answerSets) {
            for (Literal lit : answerSet.getLiterals()) {
                if (predicates.contains(lit.getPredicate())) continue;
                predicates.add(lit.getPredicate());
            }
        }
        Collections.sort(predicates);
        return predicates;
    }

    public List<String> getPredicatesWithArity() {
        ArrayList<String> predicates = new ArrayList<String>();
        for (AnswerSet answerSet : this.answerSets) {
            for (Literal lit : answerSet.getLiterals()) {
                String name = String.valueOf(lit.getPredicate()) + " / " + lit.getTerms().size();
                if (predicates.contains(name)) continue;
                predicates.add(name);
            }
        }
        Collections.sort(predicates);
        return predicates;
    }

    public List<AnswerSet> getAnswerSets() {
        return this.answerSets;
    }

    public String toString() {
        String result = "";
        for (AnswerSet answerSet : this.getAnswerSets()) {
            result = String.valueOf(result) + answerSet.toString() + "\n";
        }
        return result;
    }
}

