<!--
/**
 * JS-Funktionen fuer das Handling mit Fenstern und Popups
 *
 * (c) www.lemontree.at
 *
 * @author Gerhard Buchecker <gbuchecker@lemontree.at>
 * @package at.lemontree
 * @since Tue May 05 16:27:49 CEST 2009
 *
 *********************************************************************************/

/*--------------------------------------------------------------------------------*/

    /**
     * oeffnet ein Standard Popup-Fenster analog window.open() und setzt den Fokus darauf
     * Als Rueckgabewert wird false gegeben um die Ausfuehrung des hrefs abzubrechen
     *
     * @param String url Url des Fensters
     * @param String name Name des Fensters
     * @param String attributes Attribute des Fensters
     * @return boolean
     */
    function openWin(url, name, attributes) {
    	var newWin = open(url, name, attributes);
    	newWin.focus();
    	return false;
    }

    /*--------------------------------------------------------------------------------*/
    /**
     * oeffnet ein Popup-Fenster ohne Menueleisten u.dgl.
     * und setzt den Fokus darauf.
     * Wenn fuer den optionalen Parameter boolCenter "true"
     * uebergeben wird, wird das Popup zentriert ausgegeben.
     * Als Rueckgabewert wird false gegeben um die Ausfuehrung des hrefs abzubrechen
     *
     * @param String url Url des Fensters
     * @param boolean[optional] center zentrierte Ausgabe (true|false)
     * @param int[optional] intWidth Breite des Popups (Standardwert = 400)
     * @param int[optional] intHeight Hoehe des Popups (Standardwert = 150)
     * @param boolean[optional] boolScrollbars Anzeige der scrollbars
     * @return boolean
     */
    function openPopup(url, boolCenter, intWidth, intHeight, boolScrollbars) {

        // Standardwerte fuer die Fenstergroesze
        if (intWidth == null)  intWidth  = 400;
        if (intHeight == null) intHeight = 150;

        // Anzeige der Scrollbars festlegen
        if (boolScrollbars == null || boolScrollbars == false) {
            var strScrollbars = ',scrollbars=no';
        } else {
            var strScrollbars = ',scrollbars=yes';
        }

        if (boolCenter != null && boolCenter) {
            var newWin = openDialog(url, 'newWin', intWidth, intHeight, boolScrollbars);
        } else {
            var newWin = window.open(url, 'newWin', 'width=' + intWidth + ',height=' + intHeight + strScrollbars + ',menubar=no,resizable=yes');
        }

    	newWin.focus();
    	return false;
    }

    /*--------------------------------------------------------------------------------*/
    /**
     * Oeffnen eines Dialog-Fensters ohne menubar, scrollbar und statusleiste
     * Das Fenster wird zentriert ausgegeben und erhaelt automatisch den Focus
     * Die Referenz auf den Fensternamen wird zurueckgegeben
     *
     * @param String strUrl Url des Fensters
     * @param String strWinName Name des Popup-Fensters
     * @param int[optional] intWidth Breite des Popups (Standardwert = 400)
     * @param int[optional] intHeight Hoehe des Popups (Standardwert = 150)
     * @param boolean[optional] boolScrollbars Anzeige der scrollbars
     * @return String
     */
    function openDialog(strUrl, strWinName, intWidth, intHeight, boolScrollbars) {

        if (intWidth == null)  intWidth  = 400;
        if (intHeight == null) intHeight = 150;

        // Anzeige der Scrollbars festlegen
        if (boolScrollbars == null || boolScrollbars == false) {
            var strScrollbars = ',scrollbars=no';
        } else {
            var strScrollbars = ',scrollbars=yes';
        }

        /* Ermittlung der zentrierten Position des Fensters */
        var strLeft = '';
        var strTop  = '';

        var intLeft = getPopupPositionLeft(intWidth);
        if (intLeft >= 0) strLeft = ',left=' + intLeft;

        var intTop = getPopupPositionTop(intHeight);
        if (intTop >= 0) strTop = ',top=' + intTop;

        strWinName = window.open(strUrl, strWinName, 'width=' + intWidth + ',height=' + intHeight + strLeft + strTop + strScrollbars + ',menubar=no,resizable=yes');
        strWinName.focus();
        return strWinName;
    }

    /*--------------------------------------------------------------------------------*/
    /**
     * Abfrage der inneren Breite des aktuellen Fensters in Abhaengigkeit des
     * aktuellen Browsers
     *
     * (c) quirksmode.org
     * Quelle: http://www.quirksmode.org/viewport/compatibility.html#link2
     *
     * @return int
     */
    function getInnerWidth() {
        var x;
        if (self.innerHeight) // all except Explorer
        {
        	x = self.innerWidth;
        }
        else if (document.documentElement && document.documentElement.clientHeight)
        	// Explorer 6 Strict Mode
        {
        	x = document.documentElement.clientWidth;
        }
        else if (document.body) // other Explorers
        {
        	x = document.body.clientWidth;
        }
        return x;
    }

    /*--------------------------------------------------------------------------------*/
    /**
     * Abfrage der inneren Hoehe des aktuellen Fensters in Abhaengigkeit des
     * aktuellen Browsers
     *
     * (c) quirksmode.org
     * Quelle: http://www.quirksmode.org/viewport/compatibility.html#link2
     *
     * @return int
     */
    function getInnerHeight() {
        var y;
        if (self.innerHeight) // all except Explorer
        {
        	y = self.innerHeight;
        }
        else if (document.documentElement && document.documentElement.clientHeight)
        	// Explorer 6 Strict Mode
        {
        	y = document.documentElement.clientHeight;
        }
        else if (document.body) // other Explorers
        {
        	y = document.body.clientHeight;
        }
        return y;
    }

    /*--------------------------------------------------------------------------------*/
    /**
     * Abfrage der linken Position eines Popups fuer eine am Bildschirm zentrierte Ausgabe
     *
     * @param int intWidth Breite des Popups
     * @return int
     */
    function getPopupPositionLeft(intWidth) {

        var intLeft;
        var intScreenWidth = screen.width;

        if (intScreenWidth > 0 && intScreenWidth > intWidth && intWidth > 0) {
            var intLeft = Math.floor((intScreenWidth-intWidth)/2);
        }
        return intLeft;
    }

    /*--------------------------------------------------------------------------------*/
    /**
     * Abfrage der oberen Position eines Popups fuer eine am Bildschirm ca zentrierte Ausgabe
     *
     * @param int intHeight Hoehe des Popups
     * @return int
     */
    function getPopupPositionTop(intHeight) {

        var intTop;
        var intScreenHeight  = screen.availHeight;

        if (intScreenHeight > 0 && intScreenHeight > intHeight && intHeight > 0) {
            var intTop = Math.floor((intScreenHeight-intHeight)/2);
            intTop -= 50;   // optische Korrektur
        }
        return intTop;
    }

/*--------------------------------------------------------------------------------*/
//-->