<!--
/***********************************************************************************
  *	formcheck.js
  *
  *	Diese Datei enthaelt JavaScript-Funktionen fuer die Ueberpruefung von Formularen
  *
  * (c) Gerhard Buchecker, www.lemontree.at
  *
  *********************************************************************************/


/*--------------------------------------------------------------------------------*/
/* Funktion zum Pruefen auf gueltige Mailadresse */

function invalidEmail(feld, meldung) {
	if (feld.value != "") {
		if (feld.value.indexOf("@") == -1 || feld.value.indexOf(".") == -1 || feld.value.lastIndexOf(".") > feld.value.length-3) {
			alert(meldung);
			feld.focus();
			return true;
		} else {
			return false;
		}
	}
}

/*--------------------------------------------------------------------------------*/

/* Pruefung, ob ein Formularfeld ausgefuellt wurden */
function empty(feld, meldung) {
	// Pruefung auf Text-Inhalt
	if (feld.value == "") {
		alert(meldung);
		feld.focus();
		return true;
	} else {
		return false;
	}
}

/*--------------------------------------------------------------------------------*/
/* Pruefung, ob in einem Selectfeld eine Auswahl getroffen wurde,
 * wobei das erste Feld als Information und damit leer zaehlt */

function noSelection(feld, meldung) {
	// Pruefung auf Auswahl
	if (feld.selectedIndex == 0) {
		alert(meldung);
		feld.focus();
		return true;
	} else {
		return false;
	}
}

/*--------------------------------------------------------------------------------*/
/* Pruefung, ob Optionsfeld selektiert wurde */

function notSelected(feld, meldung) {
	// Pruefung auf Auswahl
	if (feld.value == "" || feld.value == 0) {
		alert(meldung);
		feld.focus();
		return true;
	} else {
		return false;
	}
}

/*--------------------------------------------------------------------------------*/
/* Pruefung, ob in einem Auswahlfeld (radio oder checkbox) eine Auswahl getroffen wurde */

function notChecked(feld, meldung) {

	// Pruefung auf Auswahl
	var checked = false;

	if (feld[0]) {

	    var i = 0;

    	while (!checked && i<feld.length) {
    		if (feld[i].checked == true) {
    			checked = true;
    		}
    		i++;
    	}

	} else {
	    if (feld.checked == true) {
			checked = true;
		}
	}


	if (!checked) {
		alert(meldung);
		return true;
	} else {
		return false;
	}
}

/*--------------------------------------------------------------------------------*/
/* Pruefung, ob die Feldlaenge nicht ueberschritten wurde
 * In der Meldung kann der Platzhalter #zeichen# verwendet werden,
 * um die Anzahl der Zeichen um die ueberschritten wurde auszugeben. */
function toLong(feld, meldung, laenge) {
	// Pruefung auf Feldlaenge

	if (feld.value.length > laenge) {
	    meldung = meldung.replace('#zeichen#', feld.value.length - laenge);
		alert(meldung);
		feld.focus();
		return true;
	} else {
		return false;
	}
}

/*--------------------------------------------------------------------------------*/
/* Pruefung, ob die Wortanzahl nicht ueberschritten wurde
 * In der Meldung kann der Platzhalter #woerter# verwendet werden,
 * um die Anzahl der Woerter um die ueberschritten wurde auszugeben. */
function toMuchWords(feld, meldung, anzahlWoerter) {

    var arrWoerter = feld.value.split(/ /);

	if (arrWoerter.length > anzahlWoerter) {
	    meldung = meldung.replace('#woerter#', arrWoerter.length - anzahlWoerter);
		alert(meldung);
		feld.focus();
		return true;
	} else {
		return false;
	}
}

/*--------------------------------------------------------------------------------*/
/* Pruefung, ob das EU-Datumsformat gueltig ist und wandelt von einstellige auf zweistellige Angaben um */

function invalidDateEU(feld, meldung) {

	// Pruefung auf gueltiges Datumsformat (tt.mm.yyyy)
	var feldValue = feld.value;
	var richtigesDatum = true;

	if (feldValue != "") {

		var tag = feldValue.substring(0,feldValue.indexOf("."));
		var monat = feldValue.substring(feldValue.indexOf(".")+1,feldValue.lastIndexOf("."));
		var jahr = feldValue.substring(feldValue.lastIndexOf(".")+1, feldValue.length);

		if (isNaN(tag) || isNaN(monat) || isNaN(jahr)) {
			richtigesDatum = false;
		}
		if (tag < 1 || tag > 31) {
			// Tag stimmt nicht
			richtigesDatum = false;
		}
		if (monat < 1 || monat > 12) {
			// Monat stimmt nicht
			richtigesDatum = false;
		}

		if (jahr < 1) {
			// Jahr stimmt nicht
			richtigesDatum = false;
		}

		if (jahr > 9999) {
			// Jahr stimmt nicht
			richtigesDatum = false;
		}

		if (richtigesDatum) {
			feld.value = getDateEULong(feldValue);
			return false;
		} else {
			alert(meldung);
			feld.focus();
			return true;
		}
	}
}

/*--------------------------------------------------------------------------------*/
/* Pruefung, ob das US-Datumsformat gueltig ist */

function invalidDateUS(feld, meldung) {

	// Pruefung auf gueltiges Datumsformat (yyyy-mm-dd)
	var feldValue = feld.value;
	var richtigesDatum = true;

	if (feldValue != "") {

		if (feldValue.length != 10) {
		    richtigesDatum = false;
		} else {

    		var jahr = feldValue.substring(0,feldValue.indexOf("-"));
    		var monat = feldValue.substring(feldValue.indexOf("-")+1,feldValue.lastIndexOf("-"));
    		var tag = feldValue.substring(feldValue.lastIndexOf("-")+1, feldValue.length);

    		if (isNaN(tag) || isNaN(monat) || isNaN(jahr)) {
    			richtigesDatum = false;
    		}
    		if (tag < 1 || tag > 31) {
    			// Tag stimmt nicht
    			richtigesDatum = false;
    		}
    		if (monat < 1 || monat > 12) {
    			// Monat stimmt nicht
    			richtigesDatum = false;
    		}

    		if (jahr < 1) {
    			// Jahr stimmt nicht
    			richtigesDatum = false;
    		}

    		if (jahr > 9999) {
    			// Jahr stimmt nicht
    			richtigesDatum = false;
    		}
		}

		if (!richtigesDatum) {
			alert(meldung);
			feld.focus();
			return true;
		}
	}
}

/*--------------------------------------------------------------------------------*/
/* fuegt bei einziffigen Datumsformaten die fuehrende Null hinzu */

function getDateEULong(datum) {

	if (datum != "") {

		var tag = datum.substring(0,datum.indexOf("."));
		var monat = datum.substring(datum.indexOf(".")+1,datum.lastIndexOf("."));
		var jahr = datum.substring(datum.lastIndexOf(".")+1, datum.length);

		if (tag < 10 && tag.length < 2) {
			tag = "0" + tag;
		}
		if (monat < 10 && monat.length < 2) {
			monat = "0" + monat;
		}
		return (tag + "." + monat + "." + jahr);
	}
}

/*--------------------------------------------------------------------------------*/
/* Pruefung, ob das Uhrzeitformat gueltig ist */

function invalidTimeShort(feld, meldung) {
	// Pruefung auf gueltiges Uhrzeitformat (hh:mm)
	var feldValue = feld.value;
	var richtigeUhrzeit = true;
	if (feldValue.length != 5) {
		richtigeUhrzeit = false;
	} else if (isNaN(feldValue.substring(0,2)) || isNaN(feldValue.substring(3,5))) {
		richtigeUhrzeit = false;
	} else if ((feldValue.substring(2,3) != ":")) {
		richtigeUhrzeit = false;
	} else {

		var stunde = feldValue.substring(0,2);
		var minute = feldValue.substring(3,5);

		if (stunde < 0 || stunde > 24) {
			richtigeUhrzeit = false;
		}
		if (minute < 0 || minute > 59) {
			richtigeUhrzeit = false;
		}
	}

	if (richtigeUhrzeit) {
		return false;
	} else {
		alert(meldung);
		feld.focus();
		return true;
	}
}

/*--------------------------------------------------------------------------------*/
/* Pruefung auf gueltigen Zahleninhalt */

function noPosFloat(feld, meldung) {
	feld.value = feld.value.replace(",", ".");
	if (feld.value != "" && (isNaN(feld.value) || feld.value < 0)) {
		alert(meldung);
		feld.focus();
		return true;
	} else {
		return false;
	}
}

function noPosInt(feld, meldung) {
	if (feld.value != "" && (isNaN(feld.value) || feld.value < 0 || feld.value.indexOf(".") > -1)) {
		alert(meldung);
		feld.focus();
		return true;
	} else {
		return false;
	}
}

function noNumber(feld, meldung) {
	var value = feld.value.replace(",", ".");
	if (value != "" && (isNaN(value) || feld.value.indexOf('.') > 0)) {
	    // Tausender Trennzeichen und . als Komma sind nicht erlaubt
		alert(meldung);
		feld.focus();
		return true;
	} else {
		return false;
	}
}

/*--------------------------------------------------------------------------------*/
/* Dateitypen */

function getFiletype(strFilename) {

    strFilename = strFilename.toLowerCase();
    return strFilename.substring(strFilename.lastIndexOf('.')+1, strFilename.length)
}

function wrongFiletype(feld, strFiletype) {

    var strFiletypeValue = getFiletype(feld.value);

    if (strFiletypeValue != "" && strFiletypeValue != strFiletype.toLowerCase()) {
		feld.focus();
		return true;
	} else {
		return false;
	}
}

/*--------------------------------------------------------------------------------*/
/* Funktionen zur sofortigen Pruefung auf gueltige Feldinhaltstypen */

function checkTypeNumber(field) {
    if (noNumber(field, 'Bitte in diesem Feld einen gltigen Zahlenwert eingeben (ohne Tausender-Trennzeichen).')) {
        return false;
    }
    return true;
}

function checkTypeDateEU(field) {
    if (invalidDateEU(field, 'Bitte das Datum im EU-Format (t.m.jjjj) eingeben.')) {
        return false;
    }
    return true;
}

function checkTypeDateUS(field) {
    if (invalidDateUS(field, 'Bitte das Datum im US-Format (jjjj-mm-tt) eingeben.')) {
        return false;
    }
    return true;
}

function checkTypeEmail(field) {
    if (invalidEmail(field, 'Bitte kontrollieren Sie die eingegebene Emailadresse auf Vollstndigkeit bzw. Tippfehler.')) {
        return false;
    }
    return true;
}

/**
 * Pruefung auf erlaubte Dateiformat(e)
 *
 * @param object field
 * @param string strFormat erlaubtes Dateiformat, mehrere mit Komma getrennt
 * @return boolean
 */
function checkFiletype(field, strFormat) {

    var arrFormate = strFormat.split(",");
    var boolReturn = false;

    if (strFormat != "") {

        var i = 0;

        while (!boolReturn && i<arrFormate.length) {
            if (!wrongFiletype(field, arrFormate[i].replace(/ /gi, ""))) {
                boolReturn = true;
            }
            i++;
        }
    } else {
        boolReturn = true;
    }

    if (!boolReturn) {
        alert("Die Datei ist nicht im angegebenen Format. Bitte whlen Sie eine andere Datei.");
    }

    return boolReturn;
}

/*--------------------------------------------------------------------------------*/
/* Pruefung auf Sonderzeichen
 * erster Parameter ist das zu pruefende Feld
 * zweiter Patameter ist der Meldungstext
 * die weiteren optionalen Parameter sind Zeichen, die erlaubt sind
 * z.Bsp. hasSpecialCharacters(fieldText, "Fehler!", " ", "@") */

function hasSpecialCharacters() {

	var arrArgs = hasSpecialCharacters.arguments;
	var feld    = arrArgs[0];
	var meldung = arrArgs[1];
	var value   = feld.value;

	// Entfernen der erlaubten Zeichen
	if (arrArgs.length > 1) {
		for (i=2; i<arrArgs.length; i++) {
			var strReplace = eval("/" + arrArgs[i] + "/");

			while (value.indexOf(arrArgs[i]) > -1) {
				value = value.replace(strReplace, "");
			}
		}
	}

	for (j=0; j<value.length; j++) {
		if ((value.charCodeAt(j) < 48) || ((value.charCodeAt(j) > 57)
			&& (value.charCodeAt(j) < 65)) || ((value.charCodeAt(j) > 90)
			&& (value.charCodeAt(j) < 97)) || (value.charCodeAt(j) > 122)) {
				alert(meldung);
				feld.focus();
				return true;
		}
	}
	return false;
}

/*--------------------------------------------------------------------------------*/
/* findet die Indexposition eines Formularelementes */

function findElementIndex(form, field) {

	var elementFound = false;
	var elementIndex = 0;

	while (elementIndex < form.length && !elementFound) {
		if (field == form.elements[elementIndex]) {
			elementFound = true;
		} else {
			elementIndex++;
		}
	}
	return elementIndex;
}

/*--------------------------------------------------------------------------------*/
/* Selektiert ein ueber den Index bestimmtes Formularfeld, welches sich relativ
 * zur Position eines gerade aktiven (und diese Funktion ausloesenden) Feldes
 * befindet. Die relative Position und der Status werden uebergeben
 *
 * @param objForm das aktive Formular
 * @param objField das gerade aktive Formularfeld
 * @param intRelIndex relative Indexposition von der Position des aktiven Formularfeldes aus
 * @param $boolStaus Status, den das Element erhalten soll (true | false)
 */

function selectElementByIndex(objForm, objField, intRelIndex, boolStatus) {

	var intIndex = findElementIndex(objForm, objField) + intRelIndex;

	if (objForm.elements[intIndex]) {
		var objElementToSelect = objForm.elements[intIndex];

		if (objElementToSelect.type == "radio"
			|| objElementToSelect.type == "checkbox") {

			objElementToSelect.checked = boolStatus;
		}
	}
}

/*--------------------------------------------------------------------------------*/
/* Ueberpruefung der Zeichenanzahl in einem Textfeld */

function precheckTextLength(objTextfield, intLength) {
	var strText = objTextfield.value;

   	if (strText.length == intLength-5) {
		alert("Sie haben nur mehr 5 Zeichen bis zu der \nerlaubten Anzahl von " + intLength + " Zeichen zur Verfgung.");
	}
}

function checkTextLength(objTextfield, strFieldname, intLength) {
	var strText = objTextfield.value;

	if (strText.length > intLength) {

	    var intChars = (strText.length - intLength); // Anzahl Zeichen, die zu viel sind

		alert("Sie haben im Feld " + strFieldname + " die maximale Zeichenanzahl von " + intLength + " Zeichen berschritten.\nBitte krzen Sie Ihren Text um mindestens " + intChars + " Zeichen.");
		return false;
	} else {
		return true;
	}
}

/*--------------------------------------------------------------------------------*/
//-->