function clearInput(el) {
	if (el.defaultValue==el.value){ 
		el.value = "";
	}
}
function isNum(sText){
	var ValidChars = "0123456789";		
	var IsNumber = true;
	var Char;	
	for (i = 0; i < sText.length && IsNumber == true; i++){
		Char = sText.charAt(i); 
		
		if(ValidChars.indexOf(Char) == -1){
			IsNumber = false;
			}
		}	
	return IsNumber;
}
function CheckZip(invalue, min, max) {
    var invalue_zip = invalue;
    var result = true;
	
	if(invalue_zip.length < min || invalue_zip.length > max || invalue_zip == "00000" || invalue_zip == "99999"){
		result = false;
	}
    return result;
}
function checkZipSearchVal() {
	if( validateZip( jQuery("#bankratezip").val(),'bankratezip' ) ){
		var url = jQuery("#bankrate_lookup form").attr("action")+"?pid=p:cnn&zip="+jQuery("#bankratezip").val();
		window.open (url,"");
	}
}
function CheckInsuranceSearchVal(ecid) {
	var zip = document.getElementById('zipcodeval').value;
	var insurtype = document.getElementById('InsuranceType').options[document.getElementById('InsuranceType').selectedIndex].value;
	var ecidVal = 'cnn_money_text_inssearch';
	var result_zip = false;
	var result = false;
	var errorMessage="";
	var page = jQuery("link").eq(0).attr("href");
	if( page == "http://money.cnn.com/" ){
		ecidVal = 'cnn_money_home_inssearch';
	}
	else if( page == "http://money.cnn.com/pf" ){
		ecidVal = 'cnn_money_pfhome_inssearch';
	}
	else if( page == "http://money.cnn.com/real_estate" ){
		ecidVal = 'cnn_money_rehome_inssearch';
	}

	var url = "http://www.bankrate.com/funnel/insurance/insurance-rate-quote.aspx?pid=p:cnn&InsuranceType=" + insurtype + "&zip=" + zip + "&ec_id=" + ecidVal;	

	if (isNum(zip)){
		if (CheckZip(zip, 5, 5)) {
			result_zip = true;
		}
		else {
			errorMessage = "Enter a valid 5 digit zip code.\n";
		}
	} 
	else {
		errorMessage = "Enter a valid zip code.\n";
	}
	
	if (result_zip) {
		window.open (url,"");
		//window.location = url;
	}
	else {
		alert(errorMessage);
		errorMessage = "";            
	}
	return false;
}
function ccSearch(url){

	var url = document.getElementById("ccsearch").options[document.getElementById("ccsearch").selectedIndex].value;
	window.open(url, "_blank");
}


//MORTGAGE
function wrtBankRateLinkMtg(rateType) {
	var trackingCode = '';
	var brLink = '';
	if (rateType=='30yrFixedMtg') {
		brLink = 'http://www.bankrate.com/funnel/mortgages/?pid=p:cnn&prods=1&ec_id=';
	}
	if (rateType=='15yrFixedMtg') {
		brLink = 'http://www.bankrate.com/funnel/mortgages/?pid=p:cnn&prods=2&ec_id=';
	}
	if (rateType=='30yrFixedJumboMtg') {
		brLink = 'http://www.bankrate.com/funnel/mortgages/?pid=p:cnn&prods=216&ec_id=';
	}
	if (rateType=='51Arm') {
		brLink = 'http://www.bankrate.com/funnel/mortgages/?pid=p:cnn&prods=6&ec_id=';
	}
	if (rateType=='30yrRefi') {
		brLink = 'http://www.bankrate.com/funnel/mortgages/?pid=p:cnn&prods=216&ec_id=';
	}
	if (rateType=='15yrRefi') {
		brLink = 'http://www.bankrate.com/funnel/mortgages/?pid=p:cnn&prods=215&ec_id=';
	}
	if (rateType=='51JumboArm') {
		brLink = 'http://www.bankrate.com/funnel/mortgages/?pid=p:cnn&prods=6&ec_id=';
	}
	if ( (location.pathname=='/') || (location.pathname=='/index.html') ) {
			trackingCode = 'cnn_money_home_mtg';
		} else if ( (location.pathname=='/pf/loan_center/') || (location.pathname=='/pf/loan_center/index.html') ) {
			trackingCode = 'cnn_money_pfc_loan_mtg';
/*		} else if (location.pathname.match('/magazines/moneymag/money101/lesson8/')) {
			trackingCode = 'brmint_cnn_money_101_les8_mtg';*/
		} else if ( (location.pathname=='/real_estate/') || (location.pathname=='/real_estate/index.html') ) {
			trackingCode = 'cnn_money_re_mtg';
		} else if ( (location.pathname=='/pf/') || (location.pathname=='/pf/index.html') ) {
			trackingCode = 'cnn_money_pf_mtg';
		} else {
			trackingCode = 'cnn_money_text_mtg';
	}
	return brLink + trackingCode;
}

//HOME EQUITY
function wrtBankRateLinkHE(rateType) {
	var trackingCode = '';
	var brLink = '';
	if (rateType=='30kHeloc') {
		brLink = 'http://www.bankrate.com/funnel/home-equity/?pid=p:cnn&prods=437&ec_id=';
	}
	if (rateType=='50kHeloc') {
		brLink = 'http://www.bankrate.com/funnel/home-equity/?pid=p:cnn&prods=507&ec_id=';
	}
	if (rateType=='30kHomeEq') {
		brLink = 'http://www.bankrate.com/funnel/home-equity/?pid=p:cnn&prods=438&ec_id=';
	}
	if (rateType=='50kHomeEq') {
		brLink = 'http://www.bankrate.com/funnel/home-equity/?pid=p:cnn&prods=506&ec_id=';
	}
	if (rateType=='75kHomeEq') {
		brLink = 'http://www.bankrate.com/funnel/home-equity/?pid=p:cnn&prods=457&ec_id=';
	}
	if ( (location.pathname=='/') || (location.pathname=='/index.html') ) {
			trackingCode = 'cnn_money_home_he';
		} else if ( (location.pathname=='/pf/loan_center/') || (location.pathname=='/pf/loan_center/index.html') ) {
			trackingCode = 'cnn_money_pfc_loan_he';
/*		} else if (location.pathname.match('/magazines/moneymag/money101/lesson8/')) {
			trackingCode = 'brmint_cnn_money_101_les8_he';*/
		} else if ( (location.pathname=='/real_estate/') || (location.pathname=='/real_estate/index.html') ) {
			trackingCode = 'cnn_money_re_he';
		} else if ( (location.pathname=='/pf/') || (location.pathname=='/pf/index.html') ) {
			trackingCode = 'cnn_money_pf_he';
		} else {
			trackingCode = 'cnn_money_text_he';
	}
	return brLink + trackingCode;
}

//CDs, MMAs
function wrtBankRateLinkCdMma(rateType) {
	var trackingCode = '';
	var brLink = '';
	if (rateType=='mma') {
        brLink = 'http://www.bankrate.com/funnel/savings/savings-results.aspx?pid=p:cnn&local=false&IRA=false&prods=33&ec_id=';
	}
	if (rateType=='mma10k') {
        brLink = 'http://www.bankrate.com/funnel/savings/savings-results.aspx?pid=p:cnn&local=false&IRA=false&prods=34&ec_id=';
	}
	if (rateType=='cd6mo') {
        brLink = 'http://www.bankrate.com/funnel/cd-investments/cd-investment-results.aspx?pid=p:cnn&local=false&tab=CD&prods=14&ec_id=';
	}
	if (rateType=='cd1yr') {
        brLink = 'http://www.bankrate.com/funnel/cd-investments/cd-investment-results.aspx?pid=p:cnn&local=false&tab=CD&prods=15&ec_id=';
	}
	if (rateType=='cd5yr') {
        brLink = 'http://www.bankrate.com/funnel/cd-investments/cd-investment-results.aspx?pid=p:cnn&local=false&tab=CD&prods=19&ec_id=';
	}
	if ( (location.pathname=='/') || (location.pathname=='/index.html') ) {
			trackingCode = 'cnn_money_home_cdmma';
		} else if ( (location.pathname=='/pf/loan_center/') || (location.pathname=='/pf/loan_center/index.html') ) {
			trackingCode = 'cnn_money_pfc_loan_cdmma';
/*
		} else if (location.pathname.match('/magazines/moneymag/money101/lesson3/')) {
			trackingCode = 'brmint_cnn_money_101_les3_cdmma';
*/
		} else if ( (location.pathname=='/real_estate/') || (location.pathname=='/real_estate/index.html') ) {
			trackingCode = 'cnn_money_re_he';
		} else if ( (location.pathname=='/pf/') || (location.pathname=='/pf/index.html') ) {
			trackingCode = 'cnn_money_pf_cdmma';
		} else {
			trackingCode = 'cnn_money_text_cdmma';
	}
	return brLink + trackingCode;
}

//AUTOS
function wrtBankRateLinkAuto(rateType) {
	var trackingCode = '';
	var brLink = '';
	if (rateType=='new36mo') {
		brLink = 'http://www.bankrate.com/cnn/rate/brm_autosearch.asp?product=40&refi=0&ec_id=';
	}
	if (rateType=='new48mo') {
		brLink = 'http://www.bankrate.com/cnn/rate/brm_autosearch.asp?product=39&refi=0&ec_id=';
	}
	if (rateType=='new60mo') {
		brLink = 'http://www.bankrate.com/cnn/rate/brm_autosearch.asp?product=41&refi=0&ec_id=';
	}
	if (rateType=='new72mo') {
		brLink = 'http://www.bankrate.com/cnn/rate/brm_autosearch.asp?product=311&refi=0&ec_id=';
	}
	if (rateType=='used36mo') {
		brLink = 'http://www.bankrate.com/cnn/rate/brm_autosearch.asp?product=42&refi=0&ec_id=';
	}
	if ( (location.pathname=='/') || (location.pathname=='/index.html') ) {
			trackingCode = 'brmint_cnn_money_home_auto';
		} else if ( (location.pathname=='/pf/loan_center/') || (location.pathname=='/pf/loan_center/index.html') ) {
			trackingCode = 'brmint_cnn_money_pf_loan_auto';
		} else if (location.pathname.match('/magazines/moneymag/money101/lesson17/')) {
			trackingCode = 'brmint_cnn_money_101_les17_auto';
		} else if ( (location.pathname=='/pf/') || (location.pathname=='/pf/index.html') ) {
			trackingCode = 'brmint_cnn_money_pf_home_auto';
		} else {
			trackingCode = 'brmint_cnn_money_art_auto';
	}
	return brLink + trackingCode;
}

//CREDIT CARDS
function wrtBankRateLinkCC(rateType) {
	var trackingCode = '';
	var brLink = '';
	if (rateType=='lowinterest') {
		brLink = 'http://www.bankrate.com/funnel/credit-cards/credit-card-results.aspx?pid=p:cnn&classificationuid=2&childcategoryid=109&childcategory=Low%20Interest%20Cards&classtypeuid=1&classtypedesc=Card%20Type&ec_id=';
	}
	if (rateType=='balancetransfer') {
		brLink = 'http://www.bankrate.com/funnel/credit-cards/credit-card-results.aspx?pid=p:cnn&classificationuid=3&childcategoryid=110&childcategory=Balance%20Transfer%20Cards&ec_id=';
	}
	if (rateType=='rewards') {
		brLink = 'http://www.bankrate.com/funnel/credit-cards/credit-card-results.aspx?classificationuid=8&childcategoryid=117&childcategory=Rewards%20Cards&ec_id=';
	}
	if (rateType=='cashback') {
		brLink = 'http://www.bankrate.com/funnel/credit-cards/credit-card-results.aspx?classificationuid=5&childcategoryid=114&childcategory=Cash%20Back%20Cards&ec_id=';
	}
	if (rateType=='business') {
		brLink = 'http://www.bankrate.com/funnel/credit-cards/credit-card-results.aspx?classificationuid=9&childcategoryid=118&childcategory=Business%20Cards&ec_id=';
	}
	if ( (location.pathname=='/') || (location.pathname=='/index.html') ) {
			trackingCode = 'cnn_money_home_cc';
		} else if ( (location.pathname=='/pf/loan_center/') || (location.pathname=='/pf/loan_center/index.html') ) {
			trackingCode = 'cnn_money_pfc_loan_cc';
/*		} else if (location.pathname.match('/magazines/moneymag/money101/lesson17/')) {
			trackingCode = 'brmint_cnn_money_101_les17_auto';*/
		} else if ( (location.pathname=='/real_estate/') || (location.pathname=='/real_estate/index.html') ) {
			trackingCode = 'cnn_money_re_cc';
		} else if ( (location.pathname=='/pf/') || (location.pathname=='/pf/index.html') ) {
			trackingCode = 'cnn_money_pf_cc';
		} else {
			trackingCode = 'cnn_money_text_cc';
	}
	return brLink + trackingCode;
}

//ZIP VALIDATOR tests for the following pattern w/numeric values: xxxxx or xxxxx-xxxx
function validateZip(value,whichZip) {
  var reg=/^\d{5}(\-\d{4})?$/;
  if(reg.test(value)){
    return true;
  }
  alert("Please enter a valid 5 digit or 5 digit+4 zip code.");
  document.getElementById(whichZip).focus();
  return false;
}


  /*  The following applies for the loan center page + the home page.
  **  It doesnt depend on any js libraries, is called automatically upon inclusion, and has to be added when the tables are already present
  **  It surrounds the values in the first columns of any present bank rate tables with an anchor tag
  */
var rateTableValues = (function(){
var bank_array = [
					{title:"wrtBankRateLinkMtg", param:'30yrFixedMtg'},
					{title:"wrtBankRateLinkMtg", param:'15yrFixedMtg'},
					{title:"wrtBankRateLinkMtg", param:'51Arm'},
					{title:"wrtBankRateLinkMtg", param:'30yrRefi'},
					{title:"wrtBankRateLinkMtg", param:'15yrRefi'}
];    
	if(document.getElementById("bankrate_ssi")!=null){
		var rows = document.getElementById("bankrate_ssi").getElementsByTagName("tr");
		if(rows.length > 1){
			for (var i=1;i<rows.length;i++){
				rows[i].getElementsByTagName("td")[0].innerHTML='<a href="'+wrtBankRateLinkMtg(bank_array[i-1].param)+'" target="_blank">'+rows[i].getElementsByTagName("td")[0].firstChild.nodeValue+'</a>';
			}
		}
	}

})();


/* The following function is used exclusively by the loan center tabs on the HOME page and uses jQuery.
** Its purpose is to generate any missing bank rate tables if they do not exist.
** In the end, the function calls the prexisting showNavTab function.
*/
function showNavTab0(tabId, tabNo) {
	try{
	if(jQuery("#bankrate_ssi-"+tabNo).length==0 && tabNo != 0 && tabNo !=2) {

		//clone the #bankrate_ssi div into another div. change the clone's id. insert it.
		jQuery("#bankrate_ssi").clone(true).attr("id","bankrate_ssi-"+tabNo).insertBefore("#bankrate_module #bankrate_sponsor");

		//different arrays to use
		var arrayMap = [{theArray:'cd_array'},{theArray:'home_array'},{theArray:'cc_array'}];
		var theArray = Array;

		//switch statement grabs the correct Array to use to fill in values + updates the form action acccordingly
		switch(tabNo){
			case 1:theArray=home_array; break;
			case 3:theArray=cc_array; break;
			case 4:theArray=cdmma_array; break;
			default:break;
		}

		//if the new table has fewer rows or more rows, remove rows or add rows as needed
		var rowDiff = (jQuery("#bankrate_ssi tr").length-1) - theArray.length;

		if(rowDiff > 0) {
			do {
				var removeNode = document.getElementById("bankrate_ssi-"+tabNo).getElementsByTagName("tr")[1];
				removeNode.parentNode.removeChild(removeNode);
				rowDiff--;
			} while(rowDiff > 0);
		}
		else if(rowDiff < 0) {
			do {
				var addNode = jQuery(document.getElementById("bankrate_ssi-"+tabNo).getElementsByTagName("tr")[1]).clone(true);
				jQuery(addNode).appendTo("#bankrate_ssi-"+tabNo+" table");
				rowDiff++;
			} while(rowDiff < 0);
		}

		jQuery("#bankrate_ssi-"+tabNo+" tr").each(function(i){
			if(i > 0){
				jQuery(this).find("td").eq(0).html( theArray[i-1].name );
				jQuery(this).find("td").eq(1).html( theArray[i-1].rate );
				if(theArray[i-1].change == 'S')
				{
					jQuery(this).find("td").eq(2).html('<span class="change_blank"></span>');
				}
				else if(theArray[i-1].change == 'U')
				{
					jQuery(this).find("td").eq(2).html('<span class="change_up"></span>');
				}
				else if(theArray[i-1].change == 'D')
				{
					jQuery(this).find("td").eq(2).html('<span class="change_down"></span>');
				}
				jQuery(this).find("td").eq(3).html(theArray[i-1].lweek);
			}
		});

		//linkify the first column of every row + make the background color of each row white on mouseover
		rows = document.getElementById("bankrate_ssi-"+tabNo).getElementsByTagName("tr");
		for(var i=1;i<rows.length;i++){
			if(tabNo==1)
				rows[i].getElementsByTagName("td")[0].innerHTML='<a href="'+wrtBankRateLinkHE(theArray[i-1].jsParam)+'" target="_blank">'+rows[i].getElementsByTagName("td")[0].firstChild.nodeValue+'</a>';
			else if(tabNo==3)
				rows[i].getElementsByTagName("td")[0].innerHTML='<a href="'+wrtBankRateLinkCC(theArray[i-1].jsParam)+'" target="_blank">'+rows[i].getElementsByTagName("td")[0].firstChild.nodeValue+'</a>';
			else
				rows[i].getElementsByTagName("td")[0].innerHTML='<a href="'+wrtBankRateLinkCdMma(theArray[i-1].jsParam)+'" target="_blank">'+rows[i].getElementsByTagName("td")[0].firstChild.nodeValue+'</a>';
		}
	}

	//hide tables
	jQuery("#bankrate_ssi").hide();
	for(var count=1;count<=4;count++){
		jQuery("#bankrate_ssi-"+count).hide();
	}
	//display the correct table
	if(tabNo > 0){
		if(tabNo == 2 || tabNo == 3) {
			jQuery('#bankrate_lookup').css('display','none');
			if(tabNo == 3) {
				jQuery('#bankrate_module .action-row').show();
			}
			else {
				jQuery('#bankrate_module .action-row').hide();
			}
		}
		else {
			jQuery('#bankrate_module .action-row').hide();
			jQuery('#bankrate_lookup').css('display','block');
		}
		jQuery("#bankrate_ssi-"+tabNo).show();
	}
	else{
		jQuery('#bankrate_module .action-row').hide();
		jQuery("#bankrate_ssi").show();
		jQuery('#bankrate_lookup').css('visibility','visible').css('display','block');
	}
	//set the zip code form
	if(tabNo == 0)
		jQuery("#bankrate_lookup form").attr("action","http://www.bankrate.com/funnel/mortgages/mortgage-results.aspx");
	else if(tabNo == 1)
		jQuery("#bankrate_lookup form").attr("action","http://www.bankrate.com/funnel/home-equity/home-equity-results.aspx");
	else if(tabNo == 4){
		jQuery("#bankrate_lookup form").attr("action","http://www.bankrate.com/funnel/cd-investments/cd-investment-results.aspx");
		//jQuery("#bankrate_lookup form input[name=local]").attr("val","true");
	}
	if(tabNo != 4){
		jQuery("#bankrate_lookup form input[name=local]").attr("val","false");
	}
	//highlight the correct tab using the preexisting function
	document.getElementById('bankrateBox').className='Tab'+tabNo+'Visible';
	}catch(e){}

	try{ BankrateScroll.newTabScroll(tabNo); }catch(e){}
}


if( document.getElementById('bankrate_module')!= null ) {
	var BankrateScroll = {
		list: null,
		tabNo: 0,
		time: 30000,	//ms
		clearScrollInterval: function(){
			clearInterval(jQuery(".featuredRates ul").data("interval"));
		},
		setScrollInterval: function(fun){
			if (jQuery(".featuredRates ul").data("interval")) {
				this.clearScrollInterval();
			}
			jQuery(".featuredRates ul").data("interval", setInterval(fun, BankrateScroll.time));
		},
		newTabScroll: function(tabNo){
			BankrateScroll.clearScrollInterval();
			jQuery('.ratesContainer ul li').each(function(){
				jQuery(this).hide();
			});
			switch(tabNo)
			{
				case 0:
					jQuery('.featuredRates').css('visibility','visible');
					jQuery('.featuredRates ul .bankrates-mtg').show();
					this.tabNo = 0;
					BankrateScroll.setScrollInterval(BankrateScroll.Scroll);
					break;
				case 1:
					jQuery('.featuredRates').css('visibility','visible');
					jQuery('.featuredRates ul .bankrates-homeeq').each(function(){ jQuery(this).show();  });
					this.tabNo = 1;
					BankrateScroll.setScrollInterval(BankrateScroll.Scroll);
					break;
				case 2:
					jQuery('.featuredRates').css('visibility','hidden');
					break;
				case 3:
					jQuery('.featuredRates').css('visibility','visible');
					jQuery('.featuredRates ul .bankrates-cc').each(function(){ jQuery(this).show();  });
					this.tabNo = 3;
					BankrateScroll.setScrollInterval(BankrateScroll.Scroll);
					break;
				case 4:
					jQuery('.featuredRates').css('visibility','visible');
					jQuery('.featuredRates ul .bankrates-mma-cd').each(function(){ jQuery(this).show();  });
					this.tabNo = 4;
					BankrateScroll.setScrollInterval(BankrateScroll.Scroll);
					break;
				default: break;
			}
		},
		Scroll: function(){
			if(jQuery(".featuredRates ul li:visible").length > 1){
				jQuery(".featuredRates ul li:visible").eq(0).css("display","none");
			}
			else{
				jQuery(".featuredRates ul li:visible").eq(0).css("display","none");
				BankrateScroll.clearScrollInterval();
				switch(BankrateScroll.tabNo)
				{
					case 0:
					jQuery('.featuredRates ul .bankrates-mtg').show();
					break;
					case 1:
					jQuery('.featuredRates ul .bankrates-homeeq').show();
					break;
					case 3:
					jQuery('.featuredRates ul .bankrates-cc').show();
					break;
					case 4:
					jQuery('.featuredRates ul .bankrates-mma-cd').show();
					break;
				}
				BankrateScroll.setScrollInterval(BankrateScroll.Scroll);
			}
		},
		init: function(tabNo){
			if( jQuery("link").eq(0).attr("href") != "http://money.cnn.com/")
				this.time = 10000;
			this.tabNo = tabNo;
			this.list = jQuery(".featuredRates ul");
			BankrateScroll.setScrollInterval(BankrateScroll.Scroll);
			jQuery('#insform').submit(function(){ CheckInsuranceSearchVal(); return false; });
			jQuery('#bankrate_lookup form').submit(function(){ checkZipSearchVal();return false; });
		}
	}
}

