/*
 * Library to stringify/parse JSON data. Tries to use built-in JSON functions
 * when possible and exports DISQUS.json object with two methods: stringify and
 * parse.
 *
 * This code is based on JSON library written by Douglas Crockford. Use the code
 * available at http://www.json.org/js.html as a reference.
 */

/*jslint evil: true, strict: false, regexp: false */

(function () {
    var JSON2 = {};
    var corrupted = false; // If true, Object.toJSON was overwritten to act as
                           // JSON.stringify

    function f(n) {
        // Format integers to have at least two digits.
        return n < 10 ? '0' + n : n;
    }

    if (typeof Date.prototype.toJSON !== 'function') {
        Date.prototype.toJSON = function (key) {
            return isFinite(this.valueOf()) ?
                   this.getUTCFullYear()   + '-' +
                 f(this.getUTCMonth() + 1) + '-' +
                 f(this.getUTCDate())      + 'T' +
                 f(this.getUTCHours())     + ':' +
                 f(this.getUTCMinutes())   + ':' +
                 f(this.getUTCSeconds())   + 'Z' : null;
        };

        String.prototype.toJSON =
        Number.prototype.toJSON =
        Boolean.prototype.toJSON = function (key) {
            return this.valueOf();
        };
    }

    var cx = /[\u0000\u00ad\u0600-\u0604\u070f\u17b4\u17b5\u200c-\u200f\u2028-\u202f\u2060-\u206f\ufeff\ufff0-\uffff]/g,
        escapable = /[\\\"\x00-\x1f\x7f-\x9f\u00ad\u0600-\u0604\u070f\u17b4\u17b5\u200c-\u200f\u2028-\u202f\u2060-\u206f\ufeff\ufff0-\uffff]/g,
        gap,
        indent,
        meta = {    // table of character substitutions
            '\b': '\\b',
            '\t': '\\t',
            '\n': '\\n',
            '\f': '\\f',
            '\r': '\\r',
            '"' : '\\"',
            '\\': '\\\\'
        },
        rep;

    function quote(string) {
        // If the string contains no control characters, no quote
        // characters, and no backslash characters, then we can safely
        // slap some quotes around it. Otherwise we must also replace the
        // offending characters with safe escape sequences.

        escapable.lastIndex = 0;
        return escapable.test(string) ?
            '"' + string.replace(escapable, function (a) {
                var c = meta[a];
                return typeof c === 'string' ? c :
                    '\\u' + ('0000' + a.charCodeAt(0).toString(16)).slice(-4);
            }) + '"' :
            '"' + string + '"';
    }


    function str(key, holder) {
        // Produce a string from holder[key].

        var i,          // The loop counter.
            k,          // The member key.
            v,          // The member value.
            length,
            mind = gap,
            partial,
            value = holder[key];

        // If the value has a toJSON method, call it to obtain a
        // replacement value.
        if (value && typeof value === 'object' &&
                typeof value.toJSON === 'function' && !corrupted) {
            value = value.toJSON(key);
        }

        // If we were called with a replacer function, then call the
        // replacer to obtain a replacement value.
        if (typeof rep === 'function') {
            value = rep.call(holder, key, value);
        }

        // What happens next depends on the value's type.
        switch (typeof value) {
        case 'string':
            return quote(value);
        case 'number':
            // JSON numbers must be finite. Encode non-finite numbers as
            // null.
            return isFinite(value) ? String(value) : 'null';
        case 'boolean':
        case 'null':
            // If the value is a boolean or null, convert it to a string.
            // Note: typeof null does not produce 'null'. The case is
            // included here in the remote chance that this gets fixed
            // someday.
            return String(value);
        case 'object':
            // If the type is 'object', we might be dealing with an object
            // or an array or null.
            
            // Due to a specification blunder in ECMAScript, typeof null 
            // is 'object', so watch out for that case.
            if (!value) {
                return 'null';
            }

            // Make an array to hold the partial results of stringifying
            // this object value.
            gap += indent;
            partial = [];

            // Is the value an array?
            if (Object.prototype.toString.apply(value) === '[object Array]') {
                // The value is an array. Stringify every element.
                // Use null as a placeholder for non-JSON values.
                length = value.length;
                for (i = 0; i < length; i += 1) {
                    partial[i] = str(i, value) || 'null';
                }

                // Join all of the elements together, separated with commas,
                // and wrap them in brackets.
                v = partial.length === 0 ? '[]' :
                    gap ? '[\n' + gap +
                            partial.join(',\n' + gap) + '\n' +
                                mind + ']' :
                          '[' + partial.join(',') + ']';
                gap = mind;
                return v;
            }

            // If the replacer is an array, use it to select the members
            // to be stringified.
            if (rep && typeof rep === 'object') {
                length = rep.length;
                for (i = 0; i < length; i += 1) {
                    k = rep[i];
                    if (typeof k === 'string') {
                        v = str(k, value);
                        if (v) {
                            partial.push(quote(k) + (gap ? ': ' : ':') + v);
                        }
                    }
                }
            } else {
                // Otherwise, iterate through all of the keys in the object.
                for (k in value) {
                    if (Object.hasOwnProperty.call(value, k)) {
                        v = str(k, value);
                        if (v) {
                            partial.push(quote(k) + (gap ? ': ' : ':') + v);
                        }
                    }
                }
            }

            // Join all of the member texts together, separated with commas,
            // and wrap them in braces.
            v = partial.length === 0 ? '{}' :
                gap ? '{\n' + gap + partial.join(',\n' + gap) + '\n' +
                        mind + '}' : '{' + partial.join(',') + '}';
            gap = mind;
            return v;
        }
    }

    JSON2.stringify = function (value, replacer, space) {
        // The stringify method takes a value and an optional
        // replacer, and an optional space parameter, and returns
        // a JSON text. The replacer can be a function that can replace
        // values, or an array of strings that will select the keys.
        // A default replacer method can be provided. Use of the space
        // parameter can produce text that is more easily readable.
        var i;
        gap = '';
        indent = '';

        // If the space parameter is a number, make an indent string
        // containing that many spaces.
        if (typeof space === 'number') {
            for (i = 0; i < space; i += 1) {
                indent += ' ';
            }

        // If the space parameter is a string, it will be used as
        // the indent string.
        } else if (typeof space === 'string') {
            indent = space;
        }

        // If there is a replacer, it must be a function or an array.
        // Otherwise, throw an error.
        rep = replacer;
        if (replacer && typeof replacer !== 'function' &&
                (typeof replacer !== 'object' ||
                 typeof replacer.length !== 'number')) {
            throw new Error('JSON.stringify');
        }

        // Make a fake root object containing our value under the key
        // of ''. Return the result of stringifying the value.
        return str('', {'': value});
    };

    // If the JSON object does not yet have a parse method, give it one.
    JSON2.parse = function (text, reviver) {
        // The parse method takes a text and an optional reviver
        // function, and returns a JavaScript value if the text is
        // a valid JSON text.

        // Reference comments (description of stages, etc.) were removed
        // from this copy. Use original JSON2.js library as a reference.

        var j;

        function walk(holder, key) {
            // The walk method is used to recursively walk
            // the resulting structure so that modifications can be made.
            var k, v, value = holder[key];
            if (value && typeof value === 'object') {
                for (k in value) {
                    if (Object.hasOwnProperty.call(value, k)) {
                        v = walk(value, k);
                        if (v !== undefined) {
                            value[k] = v;
                        } else {
                            delete value[k];
                        }
                    }
                }
            }
            return reviver.call(holder, key, value);
        }

        text = String(text);
        cx.lastIndex = 0;
        if (cx.test(text)) {
            text = text.replace(cx, function (a) {
                return '\\u' +
                    ('0000' + a.charCodeAt(0).toString(16)).slice(-4);
            });
        }

        if (/^[\],:{}\s]*$/
            .test(text.replace(/\\(?:["\\\/bfnrt]|u[0-9a-fA-F]{4})/g, '@')
            .replace(/"[^"\\\n\r]*"|true|false|null|-?\d+(?:\.\d*)?(?:[eE][+\-]?\d+)?/g, ']')
            .replace(/(?:^|:|,)(?:\s*\[)+/g, ''))) {

            j = eval('(' + text + ')');

            return typeof reviver === 'function' ?
                walk({'': j}, '') : j;
        }

        // If the text is not JSON parseable, then a SyntaxError is
        // thrown.
        throw new SyntaxError('JSON.parse');
    };

    // Create DISQUS.json object that contains either pointers to the functions
    // defined above or to browser's built-in functions. Code to detect valid
    // JSON instances was taken from easyXDM library.

    DISQUS.json = {};
    var obj = {
        a: [1, 2, 3]
    }, json = "{\"a\":[1,2,3]}";

    var JSON;
    if (JSON && typeof JSON.stringify === "function" && JSON.stringify(obj).replace((/\s/g), "") === json) {
        DISQUS.json = JSON;
    }

    if (Object.toJSON) {
        if (Object.toJSON(obj).replace((/\s/g), "") === json) {
            DISQUS.json.stringify = Object.toJSON;
        }
    }

    if (typeof String.prototype.evalJSON === "function") {
        obj = json.evalJSON();
        if (obj.a && obj.a.length === 3 && obj.a[2] === 3) {
            // this is a working parse method           
            DISQUS.json.parse = function(str){
                return str.evalJSON();
            };
        }
    }

    // Test if Array.prototype.toJSON is corrupted
    (function () {
        var arr = [1, 2, 3];
        if (typeof arr.toJSON === "function") {
            arr = arr.toJSON();
            corrupted = !(arr && arr.length === 3 && arr[2] === 3);
        }
    }());

    if (!DISQUS.json.stringify || !DISQUS.json.parse) {
        // Use JSON2.js
        DISQUS.json = {
            stringify: JSON2.stringify,
            parse:     JSON2.parse
        };
    }
}());