var relatedToInclude = new Object();
var numTimesRelatedReturned = 0;
var MINIMUM_ACCEPTABLE_RELATEDS = 2;
var IMG_HOST = 'http://i.cdn.turner.com/cnn';

function relatedContent(storyTopics)
{
	var TV_INCREMENT = 1;
	var TV_DECAY = .9;
	var TV_MIN_VIEWED = 21;
	var TV_MAX_TOPICS = 20;
	var DAYS_TO_EXPIRE = 30;
	var topicList = new Array();
	var numVisits = 0;

	// Capture cookie contents and remove it
	if(storage.contains('user_topics'))
	{
		var cookieContent = storage.get('user_topics');
		numVisits = cookieContent.visits;
		var cookieTopics = cookieContent.tw_array;
		var position = 0;

		while( cookieTopics[position] )
		{
			var topicObj = new Object();
			var item = cookieTopics[position];

			topicObj.key = item.key;
			topicObj.weight = item.weight*TV_DECAY;
			topicList.push (topicObj);
			position++;
		}
	}

	numVisits++;
	for(var i=0; i<storyTopics.length; i++)
	{
		var topic = storyTopics[i];
		var found = 0;

		for(var j = 0; j<topicList.length; j++)
		{
			if(topicList[j].key == topic.key)
			{
				topicList[j].weight += TV_INCREMENT;
				found = 1;
				break;
			}
		}
		if(found == 0)
		{
			var topicObj = new Object();
			topicObj.key = topic.key;
			topicObj.weight = TV_INCREMENT;
			topicList.push( topicObj );
		}
	}
	topicList.sort(
		function(a,b)
		{
			return b.weight - a.weight;
		}
	);

	if( topicList.length > TV_MAX_TOPICS )
	{
		topicList.splice( TV_MAX_TOPICS, topicList.length - TV_MAX_TOPICS );
	}

	var myObj = { visits : numVisits, tw_array : topicList };
	var exp_Date = new Date();
	exp_Date.setTime(exp_Date.getTime()+(DAYS_TO_EXPIRE*24*60*60*1000));
	storage.put( 'user_topics', myObj, exp_Date );
	storage.save();

	// if less than specified number visited, display section relateds
	if(numVisits < TV_MIN_VIEWED || topicList.length < 3)
	{
		var sectionName=window.location.pathname.toString().split("/")[2];
		CSIManager.getInstance().call('/editionssi/sect/2.0/'+sectionName+'/section.json.html', '', 'sectionRelateds', loadSectionRelateds);
	}
	else
	{
		var topicsToDisplay = new Array();
		var startingPoint = Math.min( 3, topicList.length - 3 );

		for(var i = startingPoint; i < startingPoint + 3; i++)
		{
			topicsToDisplay.push( topicList[i] );
		}

		loadRelatedTopics( topicsToDisplay );
	}
}


function loadRelatedTopics(topicArr)
{
	var windowTimeoutDisplay = window.setTimeout("selectAndShowRelated()",10000); // After 10 seconds show the data regardless

	for(var i=0; i<topicArr.length; i++)
	{
		var myTopicObj = topicArr[i];
		CSIManager.getInstance().call('http://recommend.cnn.com/classify/service/topic', 'view=recent_json&tagKey='+myTopicObj.key+'&targetType=document&targetSite=cnn%20only&targetSite=everyone', 'relatedBox', function(topicObj)
		{
			var stories = topicObj.assets;
			for(var storyCounter=0; storyCounter<stories.length; storyCounter++)
			{
				if( stories[storyCounter].headline &&
					stories[storyCounter].site != 'moneymag' &&
					stories[storyCounter].site != 'fort' &&
					stories[storyCounter].site != 'fsb' &&
					stories[storyCounter].site != 'biz2' &&
					stories[storyCounter].siteId &&
					!isCurrentStory( stories[storyCounter].siteId ) )
				{
					relatedToInclude[ stories[storyCounter].siteId ]= stories[ storyCounter ];
				}
			}
			numTimesRelatedReturned++;
			if(numTimesRelatedReturned > 2)
			{
				return selectAndShowRelated(windowTimeoutDisplay);
			}
			else
			{
				return '';
			}
		},false,escape(myTopicObj.key));
	}
}

//Loads related topics, accepts pid of window.setTimeout
function selectAndShowRelated(pid)
{
	var keyArr = new Array();
	for( var key in relatedToInclude )
	{
		keyArr.push(key);
	}
	if(keyArr.length < MINIMUM_ACCEPTABLE_RELATEDS)
	{
		var sectionName=window.location.pathname.toString().split("/")[2];
		CSIManager.getInstance().call('/editionssi/sect/2.0/'+sectionName+'/section.json.html', '', 'sectionRelateds', loadSectionRelateds);
		return '';
	}

	var retHTML = '<div class="cnnRightColBox cnn0pxBMargin"><div class="cnnRightColRnd"><img src="'+IMG_HOST+'/.element/img/2.0/mosaic/mostpopular/roundtop.336_5.gif" width="336" height="5" border="0" alt=""></div><div class="cnnRightColBoxContent"><div><img src="'+IMG_HOST+'/.element/img/2.0/mosaic/base_skins/most_pop/RFY/RFY_header.gif" alt="" width="318" height="42"></div><p class="cnnRRRFY">Stories you may be interested in based on past browsing</p>';
	retHTML += '<table cellpadding="0" cellspacing="0" border="0" width="100%" class="cnnRRTable">';

	for( var i = 0; i<keyArr.length && i < 5; i++ )
	{
		var randomNumber = Math.floor( Math.random() * keyArr.length );
		var objectToDisplay = relatedToInclude[ keyArr.splice( randomNumber, 1 ) ];
		var urlString = objectToDisplay.siteId;
		
		retHTML += '<tr><td>';
		if(objectToDisplay.wool != '' && objectToDisplay.wool != 'CNN.com')
		{
			retHTML+= '<span style="color:#949494">'+objectToDisplay.wool+'</span> ';
		}
		if(objectToDisplay["site-display-text"] == 'CNNMoney' || objectToDisplay["site-display-text"] == 'SI.com')
		{
			urlString = objectToDisplay["site-url"] + objectToDisplay.siteId;
		}
		else if(objectToDisplay["site-display-text"] == 'Time')
		{
			urlString = objectToDisplay["site-url"] + objectToDisplay.siteId.replace(/^\/time\//,'/');
		}

		if(urlString.indexOf('?') > -1) { urlString += '&iref=werecommend'; }
		else { urlString += '?iref=werecommend'; }

		retHTML += '<a href="'+urlString+'">'+objectToDisplay.headline+'</a>';
		if(objectToDisplay.videoAttached == 'true')
		{
			retHTML += '&nbsp;<img src="'+IMG_HOST+'/.element/img/2.0/global/icons/video_icon.gif" width="16" height="10" border="0" alt="" class="cnnVidIcon">';
		}
		retHTML += '</td><td class="cnnRRImgCol">&nbsp;</td></tr>';
	}
	retHTML+='</table>';
	retHTML += '</div><div class="cnnRightColRnd"><img src="'+IMG_HOST+'/.element/img/2.0/mosaic/mostpopular/roundbot.336_5.gif" width="336" height="5" border="0" alt=""></div></div>';

	window.clearTimeout(pid);
	if(document.getElementById('relatedBox') && document.getElementById('relatedBox').style && document.getElementById('relatedBox').style.display)
	{
		document.getElementById('relatedBox').style.display='inline';
	}
	document.displayRelatedsBox=true;
	return retHTML;
}

//loads the top stories from appropriate section from APS-generated JSON
function loadSectionRelateds(sectObj)
{
	var maxStories = 5;
	var retHTML = '<div class="cnnRightColBox cnn0pxBMargin"><div class="cnnRightColRnd">'
		+ '<img src="'+IMG_HOST+'/.element/img/2.0/mosaic/mostpopular/roundtop.336_5.gif" width="336" height="5" border="0" alt="">'
		+ '</div><div class="cnnRightColBoxContent"><div>'
		+ '<img src="'+IMG_HOST+'/.element/img/2.0/mosaic/base_skins/most_pop/RFY/RFY_header.gif" alt="" width="318" height="42">'
		+ '</div><p class="cnnRRRFY">Stories you may be interested in based on past browsing</p>'
		+ '<table cellpadding="0" cellspacing="0" border="0" width="100%" class="cnnRRTable">';
	for(var i=0; i < maxStories; i++)
	{
		var story = sectObj.stories[i];
		var urlString = story.url;
		var wool = '';
		if( !isCurrentStory( urlString ) )
		{
			if( story.url.match(/^\/money\//) )
			{
				wool = '<span style="color:#949494">CNNMoney.com:</span> ';
				urlString = story.url.replace(/^\/money\//,'http://money.cnn.com/');
			}
			else if( story.url.match(/^\/si\//) )
			{
				wool = '<span style="color:#949494">SI.com:</span> ';
				urlString = story.url.replace(/^\/si\//,'http://sportsillustrated.cnn.com/');
			}
			else if( story.url.match(/^\/time\//) )
			{
				wool = '<span style="color:#949494">Time.com:</span> ';
				urlString = story.url.replace(/^\/time\//,'http://www.time.com/');
			}

			if(urlString.indexOf('?') > -1) { urlString += '&iref=werecommend'; }
			else { urlString += '?iref=werecommend'; }

			retHTML += '<tr><td>'+wool+'<a href="'+urlString+'">'+story.headline+'</a>';
			if(story.videoAttached == 'true')
			{
				retHTML += '&nbsp;<img src="'+IMG_HOST+'/.element/img/2.0/global/icons/video_icon.gif" width="16" height="10" border="0" alt="" class="cnnVidIcon">';
			}
			retHTML += '</td><td class="cnnRRImgCol">&nbsp;</td></tr>';
		}
	}
	retHTML += '</table>';
	retHTML += '</div><div class="cnnRightColRnd"><img src="'+IMG_HOST+'/.element/img/2.0/mosaic/mostpopular/roundbot.336_5.gif" width="336" height="5" border="0" alt=""></div></div>';

	return retHTML;
}

function isCurrentStory( assetURL )
{	
	var relPath = assetURL.replace(/^http:\/\/[^/]*?\//, '/');
	relPath = relPath.replace(/\/[^/]*?$/, '' );
	return ( window.location.pathname.toString().indexOf(relPath) > -1 );
}
