window.StateManager = EXANIMO.managers.StateManager;

StateManager.stateChangeHandler = function(e)
{
	try {
		curcnnContentTracker.cnnChangeMosaicTab(curcnnContentTracker.getReverseStateHash(e.id),curcnnContentTracker.getStateUrl(e.id));
		if(e.id.toLowerCase() == "cnnstcvideo") {
			cnnTriggerVideo(1);
			if (cnnMpActiveId && cnnMpActiveId != 'cnnMpVideo') {
				if ($('cnnMpVideo')) {
					cnnToggleMP('cnnMpVideo', true);
				}
			}
		} else {
			if (cnnMpActiveId && cnnMpActiveId != 'cnnMpStory') {
				if ($('cnnMpStory')) {
					cnnToggleMP('cnnMpStory');
				}
			}
			if (typeof CNNPlayer != "undefined") {
				CNNPlaylistManager.getInstance().MOSUnload();
			}
		}
	} catch(e) {};
}  

function swapAd (type) {
	if (typeof cnnad_refreshAds == 'function') { 
		cnnad_refreshAds(type);
	}
}

var cnnMosaicDetect= true;
var cnnDefaultTab = null;
var cnnAnimateTabs = true;
var cnnCurrTime = new Date();
var cnnStoryPublishTime = new Date();
var cnnDefaultAdsLoaded = false;
var cnnDefault180AdsLoaded = false;
var cnnDefault336AdsLoaded = false;
pagetypeTS = "mosaic";


/* _____________________________________________________ Story font widget */

var CNN_FONT_COOKIE_NAME = "cnnFont";
var CNN_FONT_COOKIE_PATH = "/";
var CNN_FONT_COOKIE_DOMAIN = cnnCurrDomain;
var CNN_FONT_COOKIE = allCookies[ CNN_FONT_COOKIE_NAME ] || null;
var CNN_CSS_TITLE = CNN_FONT_COOKIE ? CNN_FONT_COOKIE : null;



function setActiveStyleSheet(CNN_CSS_TITLE) {
  var i, a;
  for(i=0; (a = document.getElementsByTagName("link")[i]); i++) {
    if(a.getAttribute("rel").indexOf("style") != -1 && a.getAttribute("title")) {
      a.disabled = true;
      if(a.getAttribute("title") == CNN_CSS_TITLE) a.disabled = false;
    }
  }
}

function getActiveStyleSheet() {
  var i, a;
  for(i=0; (a = document.getElementsByTagName("link")[i]); i++) {
    if(a.getAttribute("rel").indexOf("style") != -1 && a.getAttribute("title") && !a.disabled) return a.getAttribute("title");
  }
  return null;
}


Event.observe(window, 'unload', function(e) {
  if (getActiveStyleSheet() != null) {
  	if (getActiveStyleSheet() != CNN_FONT_COOKIE) {
	  	CNN_setCookie( CNN_FONT_COOKIE_NAME, getActiveStyleSheet(), 24*31, CNN_FONT_COOKIE_PATH, CNN_FONT_COOKIE_DOMAIN, '');
	}
  } else {
  	CNN_killCookie( CNN_FONT_COOKIE_NAME, CNN_FONT_COOKIE_PATH, CNN_FONT_COOKIE_DOMAIN );
  }
});


setActiveStyleSheet(CNN_CSS_TITLE);

Event.observe(window, 'load', function() {
	if ($('cnnTabNav')) {
		StateManager.initialize();	
		cnnSetClickability(curcnnContentTracker.cnnActiveTab);
	} else {
		cnnSetClickability('cnnTxtCmpnt');	
		if (typeof cnnDefaultTab == 'string') {
			CNN_omniture.Load.fetchConfigNoTab(cnnDefaultTab);
		} else {
			CNN_omniture.Load.fetchConfig('cnnTxtCmpnt');
		}
	}
});

function cnnLoadTab(url) {

	var contentDivs = $$('div#cnnHighLightTrigger div.cnnContentContainer');

	for (var i = 0; i < contentDivs.length; i++) {						document.getElementById(contentDivs[i].id).setAttribute('style','display:none');
	}

	var cnnSTCComponent = (location.hash != "") ? location.hash : '#'+cnnDefaultTab;
		switch(cnnSTCComponent.toLowerCase()) {
			case '#cnnstctext':
curcnnContentTracker.cnnInitialTabLoad('cnnTxtCmpnt','article.html');
			break;
			case '#cnnstcvideo':
curcnnContentTracker.cnnInitialTabLoad('cnnVideoCmpnt','videos.html');
			break;
			case '#cnnstcphoto':
curcnnContentTracker.cnnInitialTabLoad('cnnPhotoCmpnt','photos.html');
			break;
			case '#cnnstcother1':
curcnnContentTracker.cnnInitialTabLoad('otherTab1','other1.html');
			break;
			case '#cnnstcother2':
curcnnContentTracker.cnnInitialTabLoad('otherTab2','other2.html');
			break;
			
			default:
curcnnContentTracker.cnnInitialTabLoad('cnnTxtCmpnt','article.html');			
		}	
}

var defaultVideo = "";

function CNN_changeMosaicTab(component,url,scroll,startVideo) {
	if(startVideo!=null){
		defaultVideo = startVideo;
	}else{
		defaultVideo = "";
	}
	if (typeof(curcnnContentTracker) != "undefined") {
		if (scroll) {
			scrollTo(0,0);
		}
		StateManager.setState(curcnnContentTracker.getStateHash(component));
		CNN_omniture.Load.fetchConfig(component);
	} else {
 		return false;
	}
}


function cnnTabStripLinks() {
	var links = $$('div#cnnTabNav a');
	for (var i = 0; i <links.length; i++ ) {
		var href = links[i].getAttribute("href").toString().split('#');
		links[i].setAttribute("href","#"+href[1]);
		if (CNN.detectBrowser.isSafari()) {
			var currOnclick = links[i].getAttribute("onclick");
			currOnclick = currOnclick.replace('return false','return true');
			links[i].setAttribute("onclick",currOnclick);
		}
		
			if (CNN.detectBrowser.isIE6()) { //ugly hacks to make tab animation almost bearable in IE 6

		var ieTabBG = document.createElement("img");
		ieTabBG.setAttribute("src", "http://i.cdn.turner.com/cnn/.element/img/2.0/mosaic/tabs/bg_tab.gif");			
		ieTabBG.setAttribute("width", "123");		
		ieTabBG.setAttribute("height", "23");		
		ieTabBG.className = "tabDefaultBG";

		var leftCornerFirst = document.createElement("img");
		leftCornerFirst.setAttribute("src", "http://i.cdn.turner.com/cnn/.element/img/2.0/mosaic/tabs/bg_tab_current_first.gif");		
		leftCornerFirst.setAttribute("border", "0");		
		leftCornerFirst.setAttribute("width", "10");		
		leftCornerFirst.setAttribute("height", "29");		
		leftCornerFirst.className = "leftCornerFirst";				
			
		var leftCorner = document.createElement("img");
		leftCorner.setAttribute("src", "http://i.cdn.turner.com/cnn/.element/img/2.0/mosaic/tabs/bg_tab_current_left.gif");		
		leftCorner.setAttribute("border", "0");		
		leftCorner.setAttribute("width", "10");		
		leftCorner.setAttribute("height", "29");		
		leftCorner.className = "leftCorner";		
		
		var rightCorner = document.createElement("img");
		rightCorner.setAttribute("src", "http://i.cdn.turner.com/cnn/.element/img/2.0/mosaic/tabs/bg_tab_current_right.gif");		
		rightCorner.setAttribute("border", "0");		
		rightCorner.setAttribute("width", "10");		
		rightCorner.setAttribute("height", "29");		
		rightCorner.className = "rightCorner";		

		var rightMostCorner = document.createElement("img");
		rightMostCorner.setAttribute("src", "http://i.cdn.turner.com/cnn/.element/img/2.0/mosaic/tabs/bg_tab_current_last_ie.gif");		
		rightMostCorner.setAttribute("border", "0");		
		rightMostCorner.setAttribute("width", "12");		
		rightMostCorner.setAttribute("height", "29");		
		rightMostCorner.className = "rightCornerLast";

				links[i].parentNode.insertBefore(ieTabBG,links[i]);
				links[i].appendChild(leftCornerFirst);
				links[i].appendChild(leftCorner);
				links[i].appendChild(rightCorner);
				links[i].appendChild(rightMostCorner);
			}
	}
}

var cnnContentTracker = Class.create();

cnnContentTracker.prototype = {
	initialize: function(objName) {	
		this.cnnTxtCmpnt = false //has been loaded, is current tab;
		this.cnnVideoCmpnt = false;
		this.cnnPhotoCmpnt = false;
		this.otherTab1 = false;
		this.otherTab2 = false;
		this.cnnActiveTab = 'cnnTxtCmpnt';
		this.cnnActiveTabName='cnnMosaic_tab1';
		this.cnnPrevActiveTabName='cnnMosaic_tab1';		
		this.objName= objName;
	},
	setObjName: function(objName){
		this.objName = objName;
	},
	setValue: function(id,value) {
		switch(id) {
			case 'cnnTxtCmpnt':
				this.cnnTxtCmpnt = value;			
			break;
			case 'cnnVideoCmpnt':
				this.cnnVideoCmpnt = value;
			break;
			case 'cnnPhotoCmpnt':
				this.cnnPhotoCmpnt = value;
			break;
			case 'otherTab1':
				this.otherTab1 = value;
			break;
			case 'otherTab2':
				this.otherTab2 = value;
			break;
		}
	},
	setActiveTab: function(id){
		this.cnnActiveTab = id;
		switch(id) {
			case 'cnnTxtCmpnt':
				this.cnnActiveTabName = 'cnnMosaic_tab1';	
			break;
			case 'cnnVideoCmpnt':
				this.cnnActiveTabName = 'cnnMosaic_tab2';
			break;
			case 'cnnPhotoCmpnt':
				this.cnnActiveTabName = 'cnnMosaic_tab3';
			break;
			case 'otherTab1':
				this.cnnActiveTabName = 'cnnMosaic_tab4';
			break;
			case 'otherTab2':
				this.cnnActiveTabName = 'cnnMosaic_tab5';
			break;
		}
	},
	setPrevActiveTab: function(id) {
		this.cnnPrevActiveTab = id;		
		switch(id) {
			case 'cnnTxtCmpnt':
				this.cnnPrevActiveTabName = 'cnnMosaic_tab1';			
			break;
			case 'cnnVideoCmpnt':
				this.cnnPrevActiveTabName = 'cnnMosaic_tab2';
			break;
			case 'cnnPhotoCmpnt':
				this.cnnPrevActiveTabName = 'cnnMosaic_tab3';
			break;
			case 'otherTab1':
				this.cnnPrevActiveTabName = 'cnnMosaic_tab4';
			break;
			case 'otherTab2':
				this.cnnPrevActiveTabName = 'cnnMosaic_tab5';
			break;
		}
	
	},
	getStateHash: function(id){
	
		switch(id) {
			case 'cnnTxtCmpnt':
				return 'cnnSTCText';
			break;
			case 'cnnVideoCmpnt':
				return 'cnnSTCVideo';
			break;
			case 'cnnPhotoCmpnt':
				return 'cnnSTCPhoto';
			break;
			case 'otherTab1':
				return 'cnnSTCOther1';
			break;
			case 'otherTab2':
				return 'cnnSTCOther2';
			break;
			default:
				return 'cnnSTCText';
		}
	},
	getReverseStateHash: function(id){
	
		switch(id) {
			case 'cnnSTCText':
				return 'cnnTxtCmpnt';
			break;
			case 'cnnSTCVideo':
				return 'cnnVideoCmpnt';
			break;
			case 'cnnSTCPhoto':
				return 'cnnPhotoCmpnt';
			break;
			case 'cnnSTCOther1':
				return 'otherTab1';
			break;
			case 'cnnSTCOther2':
				return 'otherTab2';
			break;
			default:
				return 'cnnTxtCmpnt';

		}
	},	
	getStateUrl: function(id){
	
		switch(id) {
			case 'cnnSTCText':
				return 'article.html';
			break;
			case 'cnnSTCVideo':
				return 'videos.html';
			break;
			case 'cnnSTCPhoto':
				return 'photos.html';
			break;
			case 'cnnSTCOther1':
				return 'other1.html';
			break;
			case 'cnnSTCOther2':
				return 'other2.html';
			break;
			default:
				return 'article.html';
		}
	},
	cnnChangeAd: function(id,story) {
		if (cnnDefault336AdsLoaded || !$('cnnDefault336Space')) {
			if (id == 'cnnVideoCmpnt') {		
				swapAd('video');
			} else {
				swapAd('article');
			}
			if (story) {
				if (id == 'cnnTxtCmpnt') {
					curcnnContentTracker.cnnChangeStoryAd(id,1);
				} else {
					curcnnContentTracker.cnnChangeStoryAd(id);
				}
			}
		} else {
			curcnnContentTracker.cnnChangeStoryAd(id,1);
		}
	},
	cnnChangeStoryAd: function(id,initial) {
		if (initial) {
			if (id != 'cnnVideoCmpnt') {
				//fetch 336
				if ($('cnnDefault336Space') && typeof cnnDefault336Ad != 'undefined' && !cnnDefault336AdsLoaded) {
					cnnUpdateAdInDiv('cnnDefault336Space',cnnDefault336Ad);
					cnnDefault336AdsLoaded = true;
				}
			}
			//fetch 180
			if ($('cnnDefault180Space') && typeof cnnDefault180Ad != 'undefined') {
				if (id == 'cnnTxtCmpnt') {
					cnnUpdateAdInDiv('cnnDefault180Space',cnnDefault180Ad);
					cnnDefault180AdsLoaded = true;
				} else {
					cnnFindAdInsertSpot(id); //update 180x150
				}
			}
		} else {
			cnnFindAdInsertSpot(id); //update 180x150
		}
		curcnnContentTracker.cnnChangeContextualAd(id);
	},
	cnnChangeContextualAd: function(id) {
			//fetch contextual ad
			if ($('cnnDefaultContSpace')) {
				switch(id) {
					case 'cnnPhotoCmpnt':
						if (typeof cnnPhotoContAd != "undefined") {
							cnnUpdateAdInDiv('cnnDefaultContSpace',cnnPhotoContAd);
						}
					break;
					case 'cnnVideoCmpnt':
						if (typeof cnnVideoContAd != "undefined") {
							cnnUpdateAdInDiv('cnnDefaultContSpace',cnnVideoContAd);
						}
					break;
					case 'otherTab1':
						if (typeof otherTab1ContAd != "undefined") {
							cnnUpdateAdInDiv('cnnDefaultContSpace',otherTab1ContAd);
						}
					break;
					case 'otherTab2':
						if (typeof otherTab2ContAd != "undefined") {
							cnnUpdateAdInDiv('cnnDefaultContSpace',otherTab2ContAd);
						}
					break;
					default:
						if (typeof cnnDefaultContAd != "undefined") {
							cnnUpdateAdInDiv('cnnDefaultContSpace',cnnDefaultContAd);
						}
				}
			}
	},
	cnnChangeMosaicTab: function(id,path){
			var objVal = eval(this.objName+'.'+id);//eval('curcnnContentTracker.'+id);
		if (!objVal && id != curcnnContentTracker.cnnActiveTab) {  //if the content hasn't been loaded before
			Element.hide(id);	
			curcnnContentTracker.setValue(id,true);
			curcnnContentTracker.setPrevActiveTab(curcnnContentTracker.cnnActiveTab);
			curcnnContentTracker.setActiveTab(id);
			if(id != 'cnnTxtCmpnt') {
				new Ajax.Updater({success: id}, path,
					{
						onComplete:function() {
						if (cnnAnimateTabs) {	
							curcnnContentTracker.cnnAnimateTab();
						} else {	
							curcnnContentTracker.cnnChangeMosaicDisplay();
						}
							curcnnContentTracker.cnnChangeAd(id,1);
						},
						method:'get',
						evalScripts:true,
						asynchronous:true
					}
				);
			} else {
						if (cnnAnimateTabs) {	
							curcnnContentTracker.cnnAnimateTab();
						} else {	
							curcnnContentTracker.cnnChangeMosaicDisplay();
						}
							curcnnContentTracker.cnnChangeAd(id,1);

			}
		} else if(id != curcnnContentTracker.cnnActiveTab)  { //check for active tab, fade it out if it's not the tab clicked, fade requested tab in
			curcnnContentTracker.setPrevActiveTab(curcnnContentTracker.cnnActiveTab);		
			curcnnContentTracker.setActiveTab(id);			
						if (cnnAnimateTabs) {	
							curcnnContentTracker.cnnAnimateTab();
						} else {	
							curcnnContentTracker.cnnChangeMosaicDisplay();
						}							
							curcnnContentTracker.cnnChangeAd(id,1);

		}
		
		cnnSetClickability(id); //change clickURL and PartnerID for clickability buttons
	},
	cnnAnimateTab: function() {
	var cnnFPS = ( CNN.detectBrowser.isIE6() ) ? 1 : 1;
	var myTrack = "";
	var widthDiff;
				new Effect.Scale( curcnnContentTracker.cnnActiveTabName , 181, 
					{
						fps:30,
						duration:.25,
						scaleY:false,
						scaleContent:false,
						scaleFrom:100,
						scaleMode:
							{
								originalWidth: 123
							},
						afterUpdate: function(obj) {
						widthDiff = Math.round($(obj.element.id).offsetWidth - 123);
						
						$(curcnnContentTracker.cnnPrevActiveTabName).style.width = Math.round(223 - widthDiff)+"px";
						if (widthDiff == 100) {
$(curcnnContentTracker.cnnPrevActiveTabName).className = '';						
						}
						
						myTrack += $(obj.element.id).offsetWidth;
							//$('cnnTimeStamp').innerHTML = myTrack;
							
						},
						beforeStart: function(obj) 
							{
								if ((curcnnContentTracker.cnnPrevActiveTab == 'otherTab1' || curcnnContentTracker.cnnPrevActiveTab == 'otherTab2') && CNN.detectBrowser.isIE()) {
									switch(curcnnContentTracker.cnnPrevActiveTab) {
										case 'otherTab1':
											if (document.getElementById('cnn_other1ContentSWF')) { 	
											CNN_unloadFlashMovie('cnn_other1ContentSWF');
											}
										break;
										case 'otherTab2':
											if (document.getElementById('cnn_other2ContentSWF')) { 	
											CNN_unloadFlashMovie('cnn_other2ContentSWF');
											}
										break;
									}
								}
								Element.hide(curcnnContentTracker.cnnPrevActiveTab);							
								$(obj.element.id).className = cnnCheckTab(obj.element.id);
								
							},
						afterFinish:function(obj)
							{
								$(curcnnContentTracker.cnnActiveTab).style.display = 'block';
								
								if ((curcnnContentTracker.cnnActiveTab == 'otherTab1' || curcnnContentTracker.cnnActiveTab == 'otherTab2') && CNN.detectBrowser.isIE()) {
								
									switch(curcnnContentTracker.cnnActiveTab) {
										case 'otherTab1':
											if (document.getElementById('cnn_other1ContentSWF')) { 	
											CNN_loadFlashMovie('cnn_other1ContentSWF');
											}
										break;
										case 'otherTab2':
											if (document.getElementById('cnn_other2ContentSWF')) { 	
											CNN_loadFlashMovie('cnn_other2ContentSWF');
											}
										break;
									}
								
								
								}
								
								
								if( $(obj.element).id == "cnnMosaic_tab2") {
									cnnToggleMPMod('cnnVideos');
								}else {
									cnnToggleMPMod('cnnStories');
								}
						}
					}
				);					
	},
	cnnInitialTabLoad: function(id,path){
			var objVal = eval(this.objName+'.'+id);//eval('curcnnContentTracker.'+id); if this returns true, don't want XHR
			Element.hide(id);	
			curcnnContentTracker.setValue(id,true);
			curcnnContentTracker.setPrevActiveTab(curcnnContentTracker.cnnActiveTab);
			curcnnContentTracker.setActiveTab(id);

			if(id != 'cnnTxtCmpnt' && !objVal) {
				new Ajax.Updater({success: id}, path,
					{
						onComplete:function() {
							curcnnContentTracker.cnnChangeMosaicDisplay();
							Event.observe(window, 'load', function() {
								curcnnContentTracker.cnnChangeAd(id,1);
							});
						},
						method:'get',
						evalScripts:true,
						asynchronous:true
					}
				);
			} else {
				curcnnContentTracker.cnnChangeMosaicDisplay();
				
				Event.observe(window, 'load', function() {
					curcnnContentTracker.cnnChangeAd(id,1);
				});
			}
Event.observe(window, 'load', function() {
		CNN_omniture.Load.fetchConfig(id);
});
		
	},
	cnnChangeMosaicDisplay: function() {
		$(curcnnContentTracker.cnnPrevActiveTabName).className = '';					
		Element.hide(curcnnContentTracker.cnnPrevActiveTab);
		$(curcnnContentTracker.cnnActiveTabName).className = cnnCheckTab(curcnnContentTracker.cnnActiveTabName);
		$(curcnnContentTracker.cnnPrevActiveTabName).style.width = '123px';
		$(curcnnContentTracker.cnnActiveTabName).style.width = '223px';
		$(curcnnContentTracker.cnnActiveTab).style.display = 'block';

if (curcnnContentTracker.cnnActiveTab == "cnnVideoCmpnt") {		
	cnnTriggerVideo();
}
		
	}
}


function cnnTriggerVideo(tabClick) {

vidString = 'Default';
	if (cnnDefaultTab == null || cnnDefaultTab != 'cnnSTCVideo')
		vidString = 'NonDefault';

	if (typeof videoJsonUrls != "undefined") {
		if (videoJsonUrls.length < 2) {
			vidString = 'Single'+vidString;
		} else {
			vidString = 'Multi'+vidString;
		}
	}

if (tabClick) {
	if(defaultVideo == ""){
		CNNPlaylistManager.getInstance('mos').MOSCLoadFromArray(videoJsonUrls);
	}else{
		CNNPlaylistManager.getInstance('mos').MOSCLoadFromArray(videoJsonUrls, defaultVideo);
	}
} else {
	Event.observe(window, 'load', function() {
		if(defaultVideo == ""){
			CNNPlaylistManager.getInstance('mos').MOSCLoadFromArray(videoJsonUrls);
		}else{
			CNNPlaylistManager.getInstance('mos').MOSCLoadFromArray(videoJsonUrls, defaultVideo);
		}
	});
}

}

function initcnnContentTracker() {
	curcnnContentTracker = new cnnContentTracker('curcnnContentTracker');
}

function cnnToggleMPMod(el) {
	//accordion(document.getElementById(el).getElementsByTagName('h3')[0]);
}


function setPartnerID (id) { //for clickability
	var cnnPID;
	var cnnIsIntl = (location.hostname.indexOf('edition.') > -1) ? true : false;
		switch(id) {
			case 'cnnTxtCmpnt':
				cnnPID = (cnnIsIntl) ? 212106 : 211911;
			break;
			case 'cnnVideoCmpnt':
				cnnPID = (cnnIsIntl) ? 205026 : 89487;
			break;
			case 'cnnPhotoCmpnt':
				cnnPID = (cnnIsIntl) ? 212111 : 211916;
			break;
			case 'otherTab1':
			case 'otherTab2':
				cnnPID = (cnnIsIntl) ? 212126 : 211921;
			break;
		}
			return cnnPID
	
	}

function findClickabilityPrintTop(startId)
{
	var snapshotBtn = document.getElementById(startId) || null;
	if ( snapshotBtn )
	{
		for ( var i = 0, i_item = null, i_end = snapshotBtn.childNodes.length; i < i_end; i++ )
		{
			i_item = snapshotBtn.childNodes.item(i);
			if ( (i_item.nodeType===1) && (i_item.nodeName==='DIV') && (i_item.className==='cnnSnapShotHeader') )
			{
				var storyToolsContainerNode = i_item;
				for ( var x = 0, x_item = null, x_end = storyToolsContainerNode.childNodes.length; x < x_end; x++ )
				{
					x_item = storyToolsContainerNode.childNodes.item(x);
					if ( (x_item.nodeType===1) && (x_item.nodeName==='DIV') && (x_item.className==='cnnStoryTools') )
					{
						var storyToolsNode = x_item;
						for ( var y = 0, y_item = null, y_end = storyToolsNode.childNodes.length; y < y_end; y++ )
						{
							y_item = storyToolsNode.childNodes.item(y);
							if ( (y_item.nodeType===1) && (y_item.nodeName==='UL') )
							{
								var ULcontainer = y_item;
								//now get the LIs
								for ( var z = 0, z_item = null, z_end = ULcontainer.childNodes.length; z < z_end; z++ )
								{
									z_item = ULcontainer.childNodes.item(z);
									if((z_item.nodeType===1) && (z_item.nodeName==='LI') && (z_item.className==='cnnPrintThis'))
									{
										return z_item;
										z = z_end;
									}
								}
								y = y_end;
							}	
						}
						x = x_end;
					}	
				}
				i = i_end;
			}
		}
	}
}

function findClickabilityPrintBot(startId)
{
	var snapshotBtn = document.getElementById(startId) && document.getElementById(startId).parentNode || null;
	if ( snapshotBtn )
	{
		for ( var i = 0, i_item = null, i_end = snapshotBtn.childNodes.length; i < i_end; i++ )
		{
			i_item = snapshotBtn.childNodes.item(i);
			if ( (i_item.nodeType===1) && (i_item.nodeName==='DIV') && (i_item.className==='cnnStoryToolsFooter') )
			{
				var storyToolsContainerNode = i_item;
				for ( var x = 0, x_item = null, x_end = storyToolsContainerNode.childNodes.length; x < x_end; x++ )
				{
					x_item = storyToolsContainerNode.childNodes.item(x);
					if ( (x_item.nodeType===1) && (x_item.nodeName==='DIV') && (x_item.className==='cnnStoryTools') )
					{
						var storyToolsNode = x_item;
						for ( var t = 0, t_item = null, t_end = storyToolsNode.childNodes.length; t < t_end; t++ )
						{
							t_item = storyToolsNode.childNodes.item(t);
							if ( (t_item.nodeType===1) && (t_item.nodeName==='UL') )
							{
								var ULcontainer = t_item;
								//now get the LIs
								for ( var z = 0, z_item = null, z_end = ULcontainer.childNodes.length; z < z_end; z++ )
								{
									z_item = ULcontainer.childNodes.item(z);
									if ( (z_item.nodeType===1) && (z_item.nodeName==='LI') && (z_item.className==='cnnPrintThis') )
									{
										return z_item;
										z = z_end;
									}
								}
								t = t_end;
							}
						}
						x = x_end;
					}	
				}
				i = i_end;
			}	
		}
	}
}

function cnnSetClickability(component) {
	var cnnPrintBtns = new Array();
	var lcComponent = component.toLowerCase();
	//get the top button
	cnnPrintBtns.push( findClickabilityPrintTop('cnnSnapShot') );
	cnnPrintBtns.push( findClickabilityPrintBot('cnnHighLightTrigger') );
	
	for ( var f = 0, button = null, f_end = cnnPrintBtns.length; f < f_end; f++ ) {
		button = $(cnnPrintBtns[f]);
		if (button) {
			if (lcComponent != 'cnntxtcmpnt') {
				button.hide();
			} else {
				button.show();
			}
		}
	}

	clickURL = window.location.href;		
partnerID = setPartnerID(component);
commonLoc="&fb=Y&url="+escape(getClickURL())+"&title="+escape(getClickTitle())+"&random="+Math.random()+"&partnerID="+partnerID+"&expire="+escape(getClickExpire());

}

function cnnCheckTab(tabID){
	var tabs = $$('div#cnnTabNav li');
	var firstTab = tabs[0]
	var lastTab = tabs[tabs.length - 1];
	if (tabID == firstTab.id) {
		$('cnnMainContent').className = "cnnFirstTabActive";
		return "currentLeft";
	} else if (tabID == lastTab.id) {
		$('cnnMainContent').className = "";
		return "currentRight";
	} else {
		$('cnnMainContent').className = "";
		return "current";
	}
}

//CNN namespace
var CNN = {};

CNN.detectBrowser = function() {
			var ua=navigator.userAgent.toLowerCase();
	return {
		init: function() {
		},
		isOpera: function() {
			if (ua.indexOf('opera')>-1) {
				return true;
			} else {
				return false;
			}
		},
		isSafari: function() {
			if (ua.indexOf('safari')>-1) {
				return true;
			} else {
				return false;
			}
		},
		isGecko: function() {
			if (!this.isOpera() && !this.isSafari() &&ua.indexOf('gecko')>-1) {
				return true;
			} else {
				return false;
			}
		},
		isIE: function() {
			if(!this.isOpera() && ua.indexOf('msie')>-1) {
				return true;
			} else {
				return false;
			}
		},
		isIE6: function() {
			if(this.isIE && ua.indexOf('msie 6.') > -1) {
				return true;
			} else {
				return false;
			}
		}		
	}
} ();


function CNN_changeImg(which,flag) {
	switch(which) {
		case "cnnImgChngrNxtBtn":
			switch (flag) {
				case 1:
					document.getElementById(which).src = "http://i.cdn.turner.com/cnn/.element/img/2.0/global/pic_changer/next_over.gif"
				break;
				default:
					document.getElementById(which).src = "http://i.cdn.turner.com/cnn/.element/img/2.0/global/pic_changer/next.gif"				
			}
		
		break;
		case "cnnImgChngrPrvsBtn":
			switch (flag) {
				case 1:
					document.getElementById(which).src = "http://i.cdn.turner.com/cnn/.element/img/2.0/global/pic_changer/prev_over.gif"
				break;
				default:
					document.getElementById(which).src = "http://i.cdn.turner.com/cnn/.element/img/2.0/global/pic_changer/prev.gif"				
			}		
		break;
		
		default:
	}
}


function CNN_imageChanger(id, url,numSlides,chngrPos) {
	this.id = id;
	this.url = url;
	this.chngrPos = chngrPos;
	this.numSlides = numSlides;
	this.currentSlidePos = 0;
	this.disabledNxtBtn = 'http://i.cdn.turner.com/cnn/.element/img/2.0/content/in_the_news/right_gray_btn.gif';
	this.enabledNxtBtn = 'http://i.cdn.turner.com/cnn/.element/img/2.0/global/pic_changer/next.gif';
	this.disabledPrvsBtn = 'http://i.cdn.turner.com/cnn/.element/img/2.0/content/in_the_news/left_gray_btn.gif';
	this.enabledPrvsBtn = 'http://i.cdn.turner.com/cnn/.element/img/2.0/global/pic_changer/prev.gif';
	this.nxtLnkNode;
	this.prvsLnkNode;
	this.nxtLnkActive = true;
	this.prvLnkActive = false;
	
	this.CNN_navChngInitLoad();
}

function CNN_navChngInitLoad() { //make initial http request

	var totalImg = this.numSlides + 1;
	var currentImg = this.currentSlidePos + 1;
	
			new Ajax.Updater({success: this.id}, this.url,
			{
				onComplete:function(obj) {
					$('cnnImgChngrLbl').innerHTML = currentImg + " of " + totalImg;
					CNN_ArticleChanger.CNN_navDisablePrvsBtn();
				},
				method:'get',
				evalScripts:true,
				asynchronous:true
				})
}
CNN_imageChanger.prototype.CNN_navChngInitLoad = CNN_navChngInitLoad;

function CNN_navChngFrwd() {
	if (this.currentSlidePos < this.numSlides) {
		this.currentSlidePos++;
	} else {
		this.currentSlidePos = 0;
	}
	this.url = 'imgChng/p'+this.chngrPos+'-'+this.currentSlidePos+'.exclude.html';
	this.CNN_navChngManage();
}
CNN_imageChanger.prototype.CNN_navChngFrwd = CNN_navChngFrwd;

function CNN_navChngBack() { //update pos, update url

	if (this.currentSlidePos > 0) {
		this.currentSlidePos--;
	} else {
		this.currentSlidePos = this.numSlides;
	}
	this.url = 'imgChng/p'+this.chngrPos+'-'+this.currentSlidePos+'.exclude.html';
	this.CNN_navChngManage();
}
CNN_imageChanger.prototype.CNN_navChngBack = CNN_navChngBack;

function CNN_navChngManage() { //make http request
	var url = this.url;
	var id = 'cnnImgChngrNested';
	var totalImg = this.numSlides + 1;
	var currentImg = this.currentSlidePos + 1;
	
	if(this.currentSlidePos == this.numSlides && this.nxtLnkActive) {
		this.CNN_navDisableNextBtn();
	} else {
		if (!this.nxtLnkActive) {
			this.CNN_navEnableNextBtn();
		}
	}
	
	if (this.currentSlidePos == 0) {
		this.CNN_navDisablePrvsBtn();
	} else {
		if (!this.prvsLnkActive) {
			this.CNN_navEnablePrvsBtn();
		}	
	}
	
new Effect.Opacity(id,
{
	duration:.5,
	from:1.0,
	to:0,

	afterFinish: function() {
		new Ajax.Updater({success: id}, url,
		{
			onComplete:function() {
						$('cnnImgChngrLbl').innerHTML = currentImg + " of " + totalImg;
			},
			method:'get',
			evalScripts:true,
			asynchronous:true
		})	
	}
})

}
CNN_imageChanger.prototype.CNN_navChngManage = CNN_navChngManage;

function CNN_navEnableNextBtn() {
var enabledBtn = this.enabledNxtBtn;
this.nxtLnkNode = $('cnnImgChngrNxtLbl').getElementsByTagName('a')[0];

	$('cnnImgChngrNxtBtn').src = enabledBtn;
	this.nxtLnkNode.onmouseout = function() {CNN_changeImg('cnnImgChngrNxtBtn')};
	this.nxtLnkNode.onmouseover = function() {CNN_changeImg('cnnImgChngrNxtBtn',1)};
	this.nxtLnkNode.style.cursor = 'pointer';
	this.nxtLnkNode.onclick = function() { CNN_ArticleChanger.CNN_navChngFrwd(); return false;};
	this.nxtLnkActive = true;
}
CNN_imageChanger.prototype.CNN_navEnableNextBtn = CNN_navEnableNextBtn;


function CNN_navDisableNextBtn() {
var disabledBtn = this.disabledNxtBtn;
this.nxtLnkNode = $('cnnImgChngrNxtLbl').getElementsByTagName('a')[0];

	$('cnnImgChngrNxtBtn').src = disabledBtn;
	this.nxtLnkNode.onmouseout = function() {$('cnnImgChngrNxtBtn').src = disabledBtn};
	this.nxtLnkNode.onmouseover = function() {};
	this.nxtLnkNode.style.cursor = 'default';
	this.nxtLnkNode.onclick = function() { return false;};
	this.nxtLnkActive = false;
}
CNN_imageChanger.prototype.CNN_navDisableNextBtn = CNN_navDisableNextBtn;

function CNN_navEnablePrvsBtn() {
var enabledBtn = this.enabledPrvsBtn;
this.prvsLnkNode = $('cnnImgChngrPrvsLbl').getElementsByTagName('a')[0];

	$('cnnImgChngrPrvsBtn').src = enabledBtn;
	this.prvsLnkNode.onmouseout = function() {CNN_changeImg('cnnImgChngrPrvsBtn')};
	this.prvsLnkNode.onmouseover = function() {CNN_changeImg('cnnImgChngrPrvsBtn',1)};
	this.prvsLnkNode.style.cursor = 'pointer';
	this.prvsLnkNode.onclick = function() { CNN_ArticleChanger.CNN_navChngBack(); return false;};
	this.prvsLnkActive = true;
}
CNN_imageChanger.prototype.CNN_navEnablePrvsBtn = CNN_navEnablePrvsBtn;


function CNN_navDisablePrvsBtn() {
var disabledBtn = this.disabledPrvsBtn;
this.prvsLnkNode = $('cnnImgChngrPrvsLbl').getElementsByTagName('a')[0];

	$('cnnImgChngrPrvsBtn').src = disabledBtn;
	this.prvsLnkNode.onmouseout = function() {$('cnnImgChngrPrvsBtn').src = disabledBtn};
	this.prvsLnkNode.onmouseover = function() {};
	this.prvsLnkNode.style.cursor = 'default';
	this.prvsLnkNode.onclick = function() { return false;};
	this.prvsLnkActive = false;
}
CNN_imageChanger.prototype.CNN_navDisablePrvsBtn = CNN_navDisablePrvsBtn;

function CNN_loadImg(id) {
new Effect.Opacity(id,
				{
					duration:.5,
					from:0,
					to:1.0
				});
}
 
function CNN_noFlash() {
	var cnnNoFlashMsg = "<div class=\"cnnNoFlashContainer\"><div class=\"cnnNoFlash\"><p class=\"cnnTopGraf\">This CNN.com feature is optimized for Adobe Flash Player version 8 or higher.<\/p>"
	
	if (parseInt(CNN_FlashDetect.prototype.getVersion())) {
		cnnNoFlashMsg += "<p><b>You are currently using Flash Player " + parseInt(CNN_FlashDetect.prototype.getVersion()) + "<\/b><\/p>";
	} else {
		cnnNoFlashMsg += "<p><b>You do not currently have the player installed.<\/b><\/p>";
	}
	
	cnnNoFlashMsg += "<a href=\"http://www.adobe.com/go/getflashplayer\" target=\"blank\"><img src=\"http://i.cdn.turner.com/cnn/.element/img/2.0/global/noflash/install_btn.gif\" class=\"cnnGetBtn\" width=\"155\" height=\"31\" alt=\"Get Flash Player\" border=\"0\"><\/a><\/div><\/div>";
	try {
		new Insertion.Top($(curcnnContentTracker.cnnActiveTab), cnnNoFlashMsg); 
	} catch(e) {
		Event.observe(window, 'load', function() {
			var cnnActiveFlashContainer;	
			switch(cnnDefaultTab) {
				case 'cnnSTCVideo':
					cnnActiveFlashContainer = 'cnnVideoCmpnt';
				break;
				case 'cnnSTCPhoto':
					cnnActiveFlashContainer = 'cnnPhotoCmpnt';
				break;
				case 'cnnSTCOther1':
					cnnActiveFlashContainer = 'otherTab1';
				break;
				case 'cnnSTCOther2':
					cnnActiveFlashContainer = 'otherTab2';
				break;
				case 'cnnSTCText':
				default:
					cnnActiveFlashContainer = 'cnnTxtCmpnt';

			}
			new Insertion.Top($(cnnActiveFlashContainer), cnnNoFlashMsg); 
		});
	}
}

function onEmailClicked() {
	if (typeof ET == 'function') {
		ET();
	}
}

function cnnad_refreshAdInDiv(divId)
{
	var d = document.getElementById(divId);
	var subDivs = d.getElementsByTagName('div');
	var testString = 'ad-';

	for (var i = 0; i < subDivs.length; i++)
	{
		if (subDivs[i].id.substring(0,testString.length) ==
testString)
		{
			var iframes =
subDivs[i].getElementsByTagName('iframe');
			var iframeId =
subDivs[i].id.substring(testString.length);

			for (var k = 0; k < iframes.length; k++)
			{
				if (iframes[k].id == iframeId)
				{
	
iframes[k].contentWindow.location.reload();
				}
			}
		}
	}
}

function cnnFindAdInsertSpot(id) {
var cnnStringComplete = 'ds';
var cnnTriggerAdCall = true;
	var d = document.getElementById(id);
	var subDivs = d.getElementsByTagName('div');
	for (var i = 0; i < subDivs.length; i++)
	{
		if(subDivs[i].className == 'cnnMosaicSubElementCol') {
			if (!$(id+"AdContainer")) {
				 new Insertion.Bottom(subDivs[i], "<div id=\""+id+"AdContainer\"><div class=\"cnnStoryElementBox\"><div class=\"cnnStoryElementBoxAd\"><div class=\"cnnStoryElementBoxAdHead\"><img src=\"http://i.cdn.turner.com/cnn/.element/img/2.0/content/a"+cnnStringComplete+"/advertisement.gif\" alt=\"advertisement\"></div><div id=\""+id+"AdContent\"><\/div><\/div><\/div><\/div>");
			}

	if (id == 'cnnPhotoCmpnt') {
		if (typeof cnnPhotoCmpntAd == "undefined") {
			cnnTriggerAdCall = false;
		}
		
	}
	if (id == 'cnnVideoCmpnt') {
		if (typeof cnnVideoCmpntAd == "undefined") {
			cnnTriggerAdCall = false;
		}
		
	}
	if (id == 'otherTab1') {
		if (typeof otherTab1Ad == "undefined") {
			cnnTriggerAdCall = false;
		}
		
	}
	if (id == 'otherTab2') {
		if (typeof otherTab2Ad == "undefined") {
			cnnTriggerAdCall = false;
		}
		
	}
			if (cnnTriggerAdCall) {
				cnnUpdateAdInDiv($(id+"AdContent"), eval(id+'Ad'));
			}
		}
	}

	
}

function cnnUpdateAdInDiv(id,path)
{
				new Ajax.Updater({success: id}, path,
					{
						onComplete:function() {
						},
						method:'get',
						evalScripts:true,
						asynchronous:true
					}
				);

}

CNN_omniture = {};

CNN_omniture.Load = new function() { //called when a tab is clicked. will need to trigger for default component too I guess
var configFileURL = (location.hostname.indexOf('edition.') == -1) ? "http://i.cdn.turner.com/cnn/.element/js/2.0/mosaic_omniture.js" : "http://i.cdn.turner.com/cnn/.element/js/2.0/intl_mosaic_omniture.js"; //url of our config file.

	this.fetchConfigNoTab = function(id){
		var dfltCmpntID;
		switch(id) {
			case 'cnnSTCText':
				dfltCmpntID = 'cnnTxtCmpnt';
			break;
			case 'cnnSTCVideo':
				dfltCmpntID = 'cnnVideoCmpnt';
			break;
			case 'cnnSTCPhoto':
				dfltCmpntID = 'cnnPhotoCmpnt';
			break;
			case 'cnnSTCOther1':
				dfltCmpntID = 'otherTab1';
			break;
			case 'cnnSTCOther2':
				dfltCmpntID = 'otherTab2';
			break;
			default:
				dfltCmpntID = 'cnnTxtCmpnt';

		}
		
		this.fetchConfig(dfltCmpntID);
		
	}

var cnnQueryParams = new Array(); //where we'll stuff values
 
this.fetchConfig = function(stc) {
 
 switch(stc) {
 			case 'cnnTxtCmpnt':
 			default: //stuffing content type and url into array based on component
					cnnQueryParams = [{contentType:'article',contentURL:location.pathname+'%23cnnSTCText',containerURL:location.pathname}]
			break;
			case 'cnnVideoCmpnt':
					cnnQueryParams = [{contentType:'video',contentURL:location.pathname+'%23cnnSTCVideo',containerURL:location.pathname}]
			break;
			case 'cnnPhotoCmpnt':
					cnnQueryParams = [{contentType:'photo',contentURL:location.pathname+'%23cnnSTCPhoto',containerURL:location.pathname}]
			break;
			case 'otherTab1':
					var cnnOtherTab1ContentType = ( typeof cnnOtherTab1Label != "undefined") ? cnnOtherTab1Label : 'other';
					cnnQueryParams = [{contentType:cnnOtherTab1ContentType,contentURL:location.pathname+'%23cnnSTCOther1',containerURL:location.pathname}]
			break;
			case 'otherTab2':
					var cnnOtherTab2ContentType = ( typeof cnnOtherTab2Label != "undefined") ? cnnOtherTab2Label : 'other';
					cnnQueryParams = [{contentType:cnnOtherTab2ContentType,contentURL:location.pathname+'%23cnnSTCOther2',containerURL:location.pathname}]
			break;
 }
 
 		requestConfig(); //call function that writes config js to page
		return false;
 }


	function requestConfig() {
//	alert(configFileURL);

	
	if ($('cnn_omnitureScript')) { //if the config script is already written to the page, remove it
		$('cnn_omnitureScript').remove();
	}
	
		//if(location.hostname.indexOf('edition.') == -1) {
	        var script = document.createElement('script'); //create config script
	        script.setAttribute('id','cnn_omnitureScript'); //id config script
	        script.src = configFileURL + '?contentType='+cnnQueryParams[0]['contentType']+'&contentURL='+cnnQueryParams[0]['contentURL']+'&containerURL='+cnnQueryParams[0]['containerURL']; //populate src passing values from array on query string
	        window.setTimeout( function() {
	       document.body.appendChild(script); //append as last element in the page
	       }, 1000);
		//}
	}
}

function getFlashMovieObject(movieName) {
        if (window.document[movieName]) {
                return window.document[movieName];
        }
        if (navigator.appName.indexOf("Microsoft Internet")==-1) {
                if (document.embeds && document.embeds[movieName]) {
                        return document.embeds[movieName];
                }
        } else  {
                if (document.getElementById(movieName)) {
                return document.getElementById(movieName);
                } else {
                        return null;
                }
        }
}

var cnn_other1ContentSWFString;
var cnn_other2ContentSWFString;


function CNN_unloadFlashMovie(id)
{
	var cnnTabFlashObject=getFlashMovieObject(id);
	switch(id) {
		case 'cnn_other1ContentSWF':
			cnn_other1ContentSWFString = cnnTabFlashObject.movie;
		break;
		case 'cnn_other2ContentSWF':
			cnn_other2ContentSWFString = cnnTabFlashObject.movie;
		break;
	}
	cnnTabFlashObject.movie = "about:blank";
}

function CNN_loadFlashMovie(id)
{
	var cnnTabFlashObject=getFlashMovieObject(id);
	
	switch(id) {
		case 'cnn_other1ContentSWF':
			if (typeof cnn_other1ContentSWFString == "string") {
				cnnTabFlashObject.movie = cnn_other1ContentSWFString;
			}
		break;
		case 'cnn_other2ContentSWF':
			if (typeof cnn_other2ContentSWFString == "string") {
				cnnTabFlashObject.movie = cnn_other2ContentSWFString;
			}
			break;
		}
}

