function formCheck(formobj, msgid){
	var checkView = 0;

	// name of mandatory fields
	var fieldRequired = Array("name", "location", "email", "question");
	// field description to appear in the dialog box
	var fieldDescription = Array("\"Name\"", "\"Location\"", "\"E-mail\"", "\"Question\"");
	// dialog message
	var alertMsg = "Submission isn't complete without your ";

	var l_Msg = alertMsg.length + 1;
	
	// clear error field labels...
	for(var i=0; i < fieldRequired.length; i++)
	{
		document.getElementById("lbl" + fieldRequired[i]).className = "";
	}
	
	for (i = 0; i < fieldRequired.length; i++){
		var obj = formobj.elements[fieldRequired[i]];
		if (obj){
			switch(obj.type){
			case "select-one":
				if (obj.selectedIndex == -1 || obj.options[obj.selectedIndex].value == ""){
					alertMsg += fieldDescription[i] + ", ";
					if("lbl" + fieldRequired[i])
					{
						document.getElementById("lbl" + fieldRequired[i]).className = "cnnMissing";
					}
				}
				break;
			case "select-multiple":
				if (obj.selectedIndex == -1){
					alertMsg += fieldDescription[i] + ", ";
					if("lbl" + fieldRequired[i])
					{
						document.getElementById("lbl" + fieldRequired[i]).className = "cnnMissing";
					}
				}
				break;
			case "text":
			case "textarea":
				if (obj.value == "" || obj.value == null){
					alertMsg += fieldDescription[i] + ", ";
					if("lbl" + fieldRequired[i])
					{
						document.getElementById("lbl" + fieldRequired[i]).className = "cnnMissing";
					}
				}
				break;
			default:
				if (obj.value == "" || obj.value == null){
					alertMsg += fieldDescription[i] + ", ";
					
					if("lbl" + fieldRequired[i])
					{
						document.getElementById("lbl" + fieldRequired[i]).className = "cnnMissing";
					}
				}
			}
		}
	}


	alertMsg += ";";
	alertMsg = alertMsg.replace(/, ;/, "");

	msgarray = alertMsg.split(", ");
	if(msgarray.length > 1)
	{
		msgarray.splice(msgarray.length - 2, 2, msgarray[msgarray.length - 2] + " and " + msgarray[msgarray.length - 1]);
		alertMsg = msgarray.join(", ");
	}

	if (alertMsg.length == l_Msg){
		$("cnnFormData").hide();
		$("cnnThankYou").removeClassName("cnnHidden");
		$("cnnThankYou").show();
		return true;
	}else{
		document.getElementById(msgid).innerHTML = alertMsg;
		return false;
	}
}

function cnnInitForm(form) {
	$("cnnFormData").show();
	$("cnnThankYou").hide();
	
	$(form).reset();
}

function cnnCloseForm() {
	cnnHideOverlay('cnnHealthQuestion');
	cnnInitForm('healthquestion');
}