


jQuery.fn.hint = function(blurClass) {
  if (!blurClass) blurClass = 'blur';

  return this.each(function () {
    var $input = jQuery(this),
        title  = $input.attr('title'),
        $form  = jQuery(this.form),
        $win   = jQuery(window);

    function remove() {
      if (this.value === title && $input.hasClass(blurClass)) {
        $input.val('').removeClass(blurClass);
      }
    }

    // only apply logic if the element has the attribute
    if (title) {
      // on blur, set value to title attr if text is blank
      $input.blur(function () {
        if (this.value === '') {
          $input.val(title).addClass(blurClass);
        }
      }).focus(remove).blur(); // now change all inputs to title

      // clear the pre-defined text when form is submitted
      $form.submit(remove);
      $win.unload(remove); // handles Firefox's autocomplete
    }
  });
};







  /*return this.each(function () {
    var t = jQuery(this);
    var title = t.attr('title');
    if (!title) return;

    t.focus(function() {
      if (t.val() == title) {
        t.val('');
        t.removeClass('blur');
      }
    });
    t.blur(function() {
      if (t.val() == '') {
        t.addClass('blur');
        t.val(title);
      }
    });

    // clear the pre-defined text when form is submitted
    t.parents('form:first()').submit(function(){
      if (t.val() == title) {
        t.val('');
        t.removeClass('blur');
      }
    });

    t.blur();
  });*/