S9MusicPlayer.prototype.setStateClass = function( asin, stateName ) {
	var trackPreviewContainer = document.getElementById(this.campaignNamespace + "trackPreviewContainer" + asin);
	trackPreviewContainer.className = trackPreviewContainer.className.replace( new RegExp( ' s9_trackPreviewState\\w+' ), '' );
	trackPreviewContainer.className += ' s9_trackPreviewState' + stateName; 
}

S9MusicPlayer.prototype.trackStop = function() {
	var albumSampler = document.getElementById(this.campaignNamespace + "player");
	if (albumSampler != null && this.currentlyPlaying) {
		try {
		    albumSampler.TCallLabel("/", "PausePlayback");
		    this.currentlyPlaying = false;
   		} catch(err) {
   		}
	}
}

S9MusicPlayer.prototype.trackPreviewPressed = function(asin) {
	var albumSampler = document.getElementById(this.campaignNamespace + "player");
	if (albumSampler == null) {
		return true;
	}

    var trackPreviewContainer = document.getElementById(this.campaignNamespace + "trackPreviewContainer" + asin);
    if (trackPreviewContainer && albumSampler) {
        var currentState = trackPreviewContainer.state;
        switch (currentState) {
			case this.STATEID_PLAYING:
			case this.STATEID_LOADING:
			     albumSampler.TCallLabel("/", "PausePlayback");
			     this.currentlyPlaying = false;
			     break;
			case this.STATEID_STOPPED:
			case this.STATEID_PAUSED:
			case this.STATEID_ERROR:
			case undefined:
				S9MusicPlayer.stopAllOthers(this);
				albumSampler.SetVariable("_root.asinToPlay", asin);
				albumSampler.TCallLabel("/", "PlayTrackASIN");
				this.currentlyPlaying = true;
			break;
		}
    }
    return false;
}
 
S9MusicPlayer.prototype.setTrackPreviewState = function(asin, state) {
    var trackPreviewContainer = document.getElementById(this.campaignNamespace + "trackPreviewContainer" + asin);
    var trackState = document.getElementById(this.campaignNamespace + "trackPreviewState" + asin);
    if ( trackPreviewContainer ) {
    	var newState = parseInt(state,10);
        switch (newState) {
			case this.STATEID_PLAYING:
				if( trackState ) {
					trackState.innerHTML = this.pauseText;
				}
				this.setStateClass( asin, "Playing" );
				break;
			case this.STATEID_LOADING:
				if( trackState ) {
					trackState.innerHTML = this.loadingText;
				}
				this.setStateClass( asin, "Loading" );
				break;
			case this.STATEID_STOPPED:
			case this.STATEID_PAUSED:
			case this.STATEID_ERROR:
			case undefined:
				if( trackState ) {
					trackState.innerHTML = this.playText;
				}
	        	this.setStateClass( asin, "Paused" );
	        	break;
    	}
        trackPreviewContainer.state = newState;
    }
}

S9MusicPlayer.prototype.loadSwf = function() {
   	try {
		this.flashObject = new SWFObject(this.flashAlbumSamplerPath, this.campaignNamespace + "player", "1", "1", "8", "#ffffff");
		this.flashObject.addVariable("playlist_url", this.playlistUrl);
		this.flashObject.addVariable("notifications", "1");
		this.flashObject.addVariable("single_track_mode", "0");
		this.flashObject.addVariable("allow_domain", "*");
		this.flashObject.addParam("wmode", "transparent");
		this.flashObject.addParam("scale", "noScale");
		this.flashObject.addParam("salign", "LT");
		this.flashObject.addParam("quality", "high");
		this.flashObject.addParam("allowScriptAccess", "always");
		this.flashObject.write(this.campaignNamespace + "musicPlayer");
		return;
   	} catch(err) {
   	}
	return false;
}

function S9MusicPlayer(campaignNamespace, flashAlbumSamplerPath, listOfAsinsParameters, pauseText, playText, loadingText){
	S9MusicPlayer.playerRegistry.push(this);
	
	this.campaignNamespace = campaignNamespace;
	this.flashObject = null;
	this.flashAlbumSamplerPath = flashAlbumSamplerPath;
	var host = location.host;
	this.playlistUrl = "http://" + host + "/gp/dmusic/media/sample_xspf.xspf/ref=s9_music_player?" + listOfAsinsParameters;
	this.pauseText = pauseText;
	this.playText = playText;
	this.loadingText = loadingText;
	
	this.currentlyPlaying = false;
	
	this.STATEID_LOADING = 1;
	this.STATEID_STOPPED = 2;
	this.STATEID_PAUSED  = 3;
	this.STATEID_PLAYING = 4;
	this.STATEID_ERROR   = 5;
	
	this.loadSwf();
}

if( !S9MusicPlayer.playerRegistry ) {
	S9MusicPlayer.playerRegistry = [];
}
S9MusicPlayer.stopAllOthers = function( currentPlayer ) {
	for(player in S9MusicPlayer.playerRegistry) {
		if(currentPlayer != S9MusicPlayer.playerRegistry[player]) {
			S9MusicPlayer.playerRegistry[player].trackStop();
		}
	}
}