/**
 * copyright 2009 Amazon.com
 * @author maxfund (Max Funderburk)
 */

// focus on the first field of the form
jQuery(document).ready(function(){
	jQuery("input[tabindex='1']").focus();
})

function toggle(targetId, speed) { return true;
		if (document.getElementById){
		target = document.getElementById( targetId );
			if (target.style.display == "none") {
			jQuery(document.getElementById(targetId)).show(speed);
				target.style.display = "";
			} else {
			jQuery(document.getElementById(targetId)).hide(speed);
			}
		}
};

function displayCapsWarning(e, id, box) {
      e = (e) ? e : window.event;
      
      var charCode = false;
      if (e.which) {
        charCode = e.which;
      } else if (e.keyCode) {
        charCode = e.keyCode;
      }

      // convert to actual character for clearer
      // comparison below.
      var character = String.fromCharCode(charCode);

      var shifton = false;
      if (e.shiftKey) {
        shifton = e.shiftKey;
      } else if (e.modifiers) {
        // in the case that shiftKey is not defined
        // the modifiers (3-bit number) indicates 
        // what keys are pressed. Shift cause the highest
        // order bit to be on
        shifton = !!(e.modifiers & 4);
      }
      
      var divObj = document.getElementById(id);
      // Character is between a-z
      if (character >= 'a' && character <= 'z')
        if (shifton) { // caps lock on
          divObj.style.visibility = 'visible';
          box.style.background = '#FFFFDD';
        } else {
          divObj.style.visibility = 'hidden';
          box.style.background = '#FFFFFF';
        }
      
      // Character is between A-Z
      else if (character >= 'A' && character <= 'Z')
        if (!shifton) { // caps lock on
          divObj.style.visibility = 'visible';
          box.style.background = '#FFFFDD';
        } else {
          divObj.style.visibility = 'hidden';
          box.style.background = '#FFFFFF';
        }
}

function apValidateEmail(emailFieldId) { return true;
	var email = document.getElementById(emailFieldId).value; 
	if( ((null ==  email) || (email.length < 5)) || ((email.indexOf('@') < 1) ||  (email.indexOf('.') < 3)) ) {
			// ignore the empty case, that's caught by the apCheckRequiredFields function
			if((null!=email) && (email.length != 0)) {
				jQuery(document.getElementById(emailFieldId + '_malformed_alert')).show("fast");
				jQuery(document.getElementById(emailFieldId)).addClass("ap_highlight_input");
			}
			document.getElementById(emailFieldId).focus();
			return false;
	} else {
			jQuery(document.getElementById(emailFieldId+ '_malformed_alert')).hide("fast");
			jQuery(document.getElementById(emailFieldId)).removeClass("ap_highlight_input");
			return true;
	}
}

function isInteger(str) {
      return /^\d+$/.test(str);
}

function apValidateTokenCode(tokenCodeId) { return true;
	var tokenCode = document.getElementById(tokenCodeId).value; 
	if( (null ==  tokenCode) || (tokenCode.length < 6) || (tokenCode.length > 6)
		|| (!isInteger(tokenCode))) {
			// ignore the empty case, that's caught by the apCheckRequiredFields function
			if((null!=tokenCode) && (tokenCode.length != 0)) {
				jQuery(document.getElementById(tokenCodeId + '_malformed_alert')).show("fast");
				jQuery(document.getElementById(tokenCodeId)).addClass("ap_highlight_input");
			}
			document.getElementById(tokenCodeId).focus();
			return false;
	} else {
			jQuery(document.getElementById(tokenCodeId+ '_malformed_alert')).hide("fast");
			jQuery(document.getElementById(tokenCodeId)).removeClass("ap_highlight_input");
			return true;
	}
}

function apMatchFields (fieldIds) { return true;
	if(null == fieldIds || fieldIds.length != 2) {
		return true;
	}

	// fields match
	if( document.getElementById(fieldIds[0]).value == document.getElementById(fieldIds[1]).value) {
		// hide error message if it exists and remove highlighting
		jQuery(document.getElementById(fieldIds[0] + '_mismatch_alert')).hide("fast");
		if(document.getElementById(fieldIds[0]).value != '') {
			jQuery(document.getElementById(fieldIds[0])).removeClass("ap_highlight_input");
		}
		if(document.getElementById(fieldIds[1]).value != '') {
			jQuery(document.getElementById(fieldIds[0])).removeClass("ap_highlight_input");
		}
		return true;
	} else {
		// show error message and highlight the mismatched fields	
		jQuery(document.getElementById(fieldIds[0] + '_mismatch_alert')).show("fast");
		jQuery(document.getElementById(fieldIds[0])).addClass("ap_highlight_input");
		jQuery(document.getElementById(fieldIds[1])).addClass("ap_highlight_input");
		document.getElementById(fieldIds[0]).focus();
		return false;
	}
}


function apCheckRequiredFields(formId, requiredFieldIds) { return true;
	var form = document.getElementById(formId);
	var isOk = true;			
	var first = true;
	
	for(var i=0; i < requiredFieldIds.length; i++) { 
		var field = document.getElementById(requiredFieldIds[i]);
		// Validate that the field isn't empty
		if ((null == field) || (null == field.value) || (field.value == '')) {
			// Special case for SignIn Form.  Password field can be empty
			// if user has chose 'new account' and form id is 'ap_signin_form'
				if (field.name == 'password' && formId == 'ap_signin_form' && document.getElementById('ap_signin_create_radio').checked) {
					// remove password warning
					jQuery(document.getElementById('ap_password')).removeClass('ap_highlight_input');
					jQuery(document.getElementById('ap_password_alert')).hide("fast");
					continue;
				}
			
			// show the error messages
			jQuery(document.getElementById(field.id + '_alert')).show("fast");
			
			// highlight the input field
			jQuery(document.getElementById(field.id)).addClass("ap_highlight_input");
			if (first) {
				document.getElementById(field.id).focus();
				first = false;
			}
			isOk = false;
		} else {
			// attempt to remove pre-existing highlighting for multiple attempts
			jQuery(document.getElementById(field.id)).removeClass('ap_highlight_input');
			jQuery(document.getElementById(field.id + '_alert')).hide("fast");
		}
	}
	return isOk;
}

function setElementAvailability(fieldId, available) {
    var field = document.getElementById(fieldId);
    field.disabled = !available;
    jQuery(field).removeClass(field.disabled ? 'enabled' : 'disabled');
    jQuery(field).addClass(field.disabled ? 'disabled' : 'enabled');
}

function enable(fieldId) {
	var field = document.getElementById(fieldId);
	field.disabled = false;
	jQuery(field).removeClass('disabled');
	jQuery(field).addClass('enabled');
}

function disable(fieldId) {
	var field = document.getElementById(fieldId);
	field.disabled = true;
	jQuery(field).removeClass('enabled');
	jQuery(field).addClass('disabled');
}

function matchFields(fieldId1, fieldId2) { return true;
	return document.getElementById(fieldId1).equalsIgnoreCase(document.getElementById(fieldId2));
}

function amz_js_PopWin(url,name,options){
	var ContextWindow = window.open(url,name,options);
	ContextWindow.focus();
	return false;
}

function setCookie(c_name,value,expiredays)
{
	var exdate=new Date();
	exdate.setDate(exdate.getDate()+expiredays);
	document.cookie=c_name+ "=" +escape(value)+
	((expiredays==null) ? "" : ";expires="+exdate.toGMTString());
}

function getCookie(c_name)
{
	if (document.cookie.length>0)
	{
		c_start=document.cookie.indexOf(c_name + "=");
		if (c_start!=-1)
		{
			c_start=c_start + c_name.length+1;
			c_end=document.cookie.indexOf(";",c_start);
			if (c_end==-1) c_end=document.cookie.length;
			return unescape(document.cookie.substring(c_start,c_end));
		}
	}
	return "";
}
function deleteCookie ( cookie_name )
{
  var cookie_date = new Date ( );  // current date & time
  cookie_date.setTime ( cookie_date.getTime() - 1 );
  document.cookie = cookie_name += "=; expires=" + cookie_date.toGMTString();
}
			
function checkCookieEnabled(nodeId)
{
	setCookie('amznTest','1',null);
	if(getCookie('amznTest')){
		deleteCookie('amznTest');
	}else{
		document.getElementById(nodeId).style.display = 'block';
	}
}

function updateCaptcha(appAction) {
	// remove the current captcha
	jQuery('#ap_captcha_refresh_txt > a').hide();
	jQuery('#ap_captcha_refresh_noop').show();
	jQuery('#ap_captcha_img').addClass('loading');
	jQuery('#ap_captcha_img').empty();
	jQuery.ajax({
		type: "GET",
		url: "/ap/captcha?appAction=" + appAction,
		cache: false,
		dataType: "json",
		timeout: 7000,
		success: function(msg){
			var img = new Image();
			jQuery(img).load(function() {
				  jQuery(this).hide();
			      jQuery('#ap_captcha_img').removeClass('loading').append(this);
			      jQuery(this).fadeIn();
				}
			).attr('src', msg["captchaImageUrl"]);
			jQuery('#ap_captcha_img').addClass('loading');
			jQuery('#ap_captcha_refresh_noop').hide();
			jQuery('#ap_captcha_refresh_txt > a').show();
			jQuery("[type='hidden'][name='ces']").val(msg['cesString']);
		},
		error: function (XMLHttpRequest, textStatus, errorThrown) {
			window.location.reload(true);
		}
	});	
}
